/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandRedeploy
extends AbstractCommand {
    public CommandRedeploy() {
        super("redeploy", "1. Common Commands", "[module] [plan] [ModuleID|TargetModuleID+]", "A shortcut to undeploy a module from one or more servers, then deploy a new version.  This is not a smooth cutover -- some client requests may be rejected while the redeploy takes place.\nNormally both a module and plan are passed to the deployer. Sometimes the module contains a plan, or requires no plan, in which case the plan may be omitted.  Sometimes the plan references a module already deployed in the Geronimo server environment, in which case a module does not need to be provided.\nIf more than one TargetModuleID is provided, all TargetModuleIDs must refer to the same module (just running on different targets).\nRegardless of whether the old module was running or not, the new module will be started.\nIf no ModuleID or TargetModuleID is specified, and you're deploying to Geronimo, the deployer will attempt to guess the correct ModuleID for you based on the module and/or plan you provided.\nNote: To specify a TargetModuleID, use the form TargetName|ModuleName");
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        TargetModuleID[] allModules;
        this.setOut(out);
        if (args.length == 0) {
            throw new DeploymentSyntaxException("Must specify a module or plan (or both) and optionally module IDs to replace");
        }
        DeploymentManager mgr = connection.getDeploymentManager();
        Target[] allTargets = mgr.getTargets();
        try {
            allModules = mgr.getAvailableModules(null, allTargets);
        }
        catch (TargetException e) {
            throw new DeploymentException("Unable to load modules from server", (Throwable)e);
        }
        ArrayList modules = new ArrayList();
        File module = null;
        File plan = null;
        File test = new File(args[0]);
        if (!test.exists()) {
            throw new DeploymentSyntaxException("Must specify a module or plan (or both) and optionally module IDs to replace");
        }
        if (!test.canRead()) {
            throw new DeploymentException("Cannot read file " + test.getAbsolutePath());
        }
        if (DeployUtils.isJarFile((File)test) || test.isDirectory()) {
            module = test;
        } else {
            plan = test;
        }
        if (args.length > 1) {
            test = new File(args[1]);
            if (test.exists() && test.canRead() && !args[1].equals(args[0])) {
                if (DeployUtils.isJarFile((File)test) || test.isDirectory()) {
                    if (module != null) {
                        throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                    }
                    module = test;
                } else {
                    if (plan != null) {
                        throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                    }
                    plan = test;
                }
            } else {
                modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[1], (boolean)false));
            }
        }
        for (int i = 2; i < args.length; ++i) {
            modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[i], (boolean)false));
        }
        if (modules.size() == 0 && connection.isGeronimo()) {
            this.emit("No ModuleID or TargetModuleID provided.  Attempting to guess based on the content of the " + (plan == null ? "archive" : "plan") + ".");
            String moduleId = null;
            try {
                if (plan != null) {
                    moduleId = DeployUtils.extractModuleIdFromPlan((File)plan);
                    if (moduleId == null) {
                        String fileName = module == null ? plan.getName() : module.getName();
                        int pos = fileName.lastIndexOf(46);
                        String artifactId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
                        moduleId = "default/" + artifactId + "//";
                        this.emit("Unable to locate Geronimo deployment plan in archive.  Calculating default ModuleID from archive name.");
                    }
                } else if (module != null && (moduleId = DeployUtils.extractModuleIdFromArchive((File)module)) == null) {
                    int pos = module.getName().lastIndexOf(46);
                    String artifactId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
                    moduleId = "default/" + artifactId + "//";
                    this.emit("Unable to locate Geronimo deployment plan in archive.  Calculating default ModuleID from archive name.");
                }
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to read input files: " + e.getMessage());
            }
            if (moduleId != null) {
                this.emit("Attempting to use ModuleID '" + moduleId + "'");
                modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)moduleId, (boolean)true));
            } else {
                this.emit("Unable to calculate a ModuleID from supplied module and/or plan.");
            }
        }
        if (modules.size() == 0) {
            throw new DeploymentSyntaxException("No ModuleID or TargetModuleID available.  Nothing to do.  Maybe you should add a ModuleID or TargetModuleID to the command line?");
        }
        if (module != null) {
            module = module.getAbsoluteFile();
        }
        if (plan != null) {
            plan = plan.getAbsoluteFile();
        }
        TargetModuleID[] ids = modules.toArray(new TargetModuleID[modules.size()]);
        boolean multiple = CommandRedeploy.isMultipleTargets(ids);
        ProgressObject po = mgr.redeploy(ids, module, plan);
        this.waitForProgress(out, po);
        TargetModuleID[] done = po.getResultTargetModuleIDs();
        for (int i = 0; i < done.length; ++i) {
            TargetModuleID id = done[i];
            this.emit("Redeployed " + id.getModuleID() + (multiple ? " on " + id.getTarget().getName() : "") + (id.getWebURL() == null ? "" : " @ " + id.getWebURL()));
            if (id.getChildTargetModuleID() == null) continue;
            for (int j = 0; j < id.getChildTargetModuleID().length; ++j) {
                TargetModuleID child = id.getChildTargetModuleID()[j];
                this.emit("  `-> " + child.getModuleID() + (child.getWebURL() == null ? "" : " @ " + child.getWebURL()));
            }
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }
}

