/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.console.util.ConfigurationData;
import org.apache.geronimo.console.util.ManagementHelper;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.management.AppClientModule;
import org.apache.geronimo.management.EJB;
import org.apache.geronimo.management.EJBModule;
import org.apache.geronimo.management.J2EEDeployedObject;
import org.apache.geronimo.management.J2EEModule;
import org.apache.geronimo.management.J2EEResource;
import org.apache.geronimo.management.JDBCDataSource;
import org.apache.geronimo.management.JDBCDriver;
import org.apache.geronimo.management.JDBCResource;
import org.apache.geronimo.management.JMSResource;
import org.apache.geronimo.management.Servlet;
import org.apache.geronimo.management.geronimo.J2EEApplication;
import org.apache.geronimo.management.geronimo.J2EEDomain;
import org.apache.geronimo.management.geronimo.J2EEServer;
import org.apache.geronimo.management.geronimo.JCAAdminObject;
import org.apache.geronimo.management.geronimo.JCAConnectionFactory;
import org.apache.geronimo.management.geronimo.JCAManagedConnectionFactory;
import org.apache.geronimo.management.geronimo.JCAResource;
import org.apache.geronimo.management.geronimo.JVM;
import org.apache.geronimo.management.geronimo.ResourceAdapter;
import org.apache.geronimo.management.geronimo.ResourceAdapterModule;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.system.jmx.KernelDelegate;
import org.apache.geronimo.system.logging.SystemLog;

public class KernelManagementHelper
implements ManagementHelper {
    private final Kernel kernel;

    public KernelManagementHelper(Kernel kernel) {
        this.kernel = kernel;
    }

    public J2EEDomain[] getDomains() {
        Set domainNames = this.kernel.listGBeans(new AbstractNameQuery(J2EEDomain.class.getName()));
        J2EEDomain[] result = new J2EEDomain[domainNames.size()];
        int i = 0;
        Iterator iterator = domainNames.iterator();
        while (iterator.hasNext()) {
            AbstractName domainName = (AbstractName)iterator.next();
            result[i++] = (J2EEDomain)this.kernel.getProxyManager().createProxy(domainName, class$org$apache$geronimo$management$geronimo$J2EEDomain == null ? KernelManagementHelper.class$("org.apache.geronimo.management.geronimo.J2EEDomain") : class$org$apache$geronimo$management$geronimo$J2EEDomain);
        }
        return result;
    }

    public J2EEServer[] getServers(J2EEDomain domain) {
        return domain.getServerInstances();
    }

    public J2EEDeployedObject[] getDeployedObjects(J2EEServer server) {
        return server.getDeployedObjectInstances();
    }

    public J2EEApplication[] getApplications(J2EEServer server) {
        return server.getApplications();
    }

    public AppClientModule[] getAppClients(J2EEServer server) {
        return server.getAppClients();
    }

    public WebModule[] getWebModules(J2EEServer server) {
        return server.getWebModules();
    }

    public EJBModule[] getEJBModules(J2EEServer server) {
        return server.getEJBModules();
    }

    public ResourceAdapterModule[] getRAModules(J2EEServer server) {
        return server.getResourceAdapterModules();
    }

    public JCAManagedConnectionFactory[] getOutboundFactories(J2EEServer server, String connectionFactoryInterface) {
        ArrayList<JCAManagedConnectionFactory> list = new ArrayList<JCAManagedConnectionFactory>();
        ResourceAdapterModule[] modules = server.getResourceAdapterModules();
        for (int i = 0; i < modules.length; ++i) {
            ResourceAdapterModule module = modules[i];
            ResourceAdapter[] adapters = module.getResourceAdapterInstances();
            for (int j = 0; j < adapters.length; ++j) {
                ResourceAdapter adapter = adapters[j];
                JCAResource[] resources = adapter.getJCAResourceImplementations();
                for (int k = 0; k < resources.length; ++k) {
                    JCAResource resource = resources[k];
                    JCAManagedConnectionFactory[] outboundFactories = resource.getOutboundFactories();
                    list.addAll(Arrays.asList(outboundFactories));
                }
            }
        }
        return list.toArray(new JCAManagedConnectionFactory[list.size()]);
    }

    public ResourceAdapterModule[] getOutboundRAModules(J2EEServer server, String connectionFactoryInterface) {
        return this.getOutboundRAModules(server, new String[]{connectionFactoryInterface});
    }

    public ResourceAdapterModule[] getOutboundRAModules(J2EEServer server, String[] connectionFactoryInterfaces) {
        ArrayList<ResourceAdapterModule> list = new ArrayList<ResourceAdapterModule>();
        ResourceAdapterModule[] modules = server.getResourceAdapterModules();
        block0: for (int i = 0; i < modules.length; ++i) {
            ResourceAdapterModule module = modules[i];
            ResourceAdapter[] adapters = module.getResourceAdapterInstances();
            for (int j = 0; j < adapters.length; ++j) {
                ResourceAdapter adapter = adapters[j];
                JCAResource[] resources = adapter.getJCAResourceImplementations();
                for (int k = 0; k < resources.length; ++k) {
                    JCAResource resource = resources[k];
                    JCAManagedConnectionFactory[] outboundFactories = resource.getOutboundFactories(connectionFactoryInterfaces);
                    if (outboundFactories.length <= 0) continue;
                    list.add(module);
                    continue block0;
                }
            }
        }
        return list.toArray(new ResourceAdapterModule[list.size()]);
    }

    public ResourceAdapterModule[] getAdminObjectModules(J2EEServer server, String[] adminObjectInterfaces) {
        ArrayList<ResourceAdapterModule> list = new ArrayList<ResourceAdapterModule>();
        ResourceAdapterModule[] modules = server.getResourceAdapterModules();
        block0: for (int i = 0; i < modules.length; ++i) {
            ResourceAdapterModule module = modules[i];
            ResourceAdapter[] adapters = module.getResourceAdapterInstances();
            for (int j = 0; j < adapters.length; ++j) {
                ResourceAdapter adapter = adapters[j];
                JCAResource[] resources = adapter.getJCAResourceImplementations();
                for (int k = 0; k < resources.length; ++k) {
                    JCAResource resource = resources[k];
                    JCAAdminObject[] adminObjects = resource.getAdminObjectInstances(adminObjectInterfaces);
                    if (adminObjects.length <= 0) continue;
                    list.add(module);
                    continue block0;
                }
            }
        }
        return list.toArray(new ResourceAdapterModule[list.size()]);
    }

    public JCAManagedConnectionFactory[] getOutboundFactories(ResourceAdapterModule module) {
        return this.getOutboundFactories(module, (String[])null);
    }

    public JCAManagedConnectionFactory[] getOutboundFactories(ResourceAdapterModule module, String connectionFactoryInterface) {
        return this.getOutboundFactories(module, new String[]{connectionFactoryInterface});
    }

    public JCAManagedConnectionFactory[] getOutboundFactories(ResourceAdapterModule module, String[] connectionFactoryInterfaces) {
        ArrayList<JCAManagedConnectionFactory> list = new ArrayList<JCAManagedConnectionFactory>();
        ResourceAdapter[] resourceAdapters = module.getResourceAdapterInstances();
        for (int i = 0; i < resourceAdapters.length; ++i) {
            ResourceAdapter resourceAdapter = resourceAdapters[i];
            JCAResource[] jcaResources = resourceAdapter.getJCAResourceImplementations();
            for (int j = 0; j < jcaResources.length; ++j) {
                JCAResource jcaResource = jcaResources[j];
                JCAManagedConnectionFactory[] outboundFactories = jcaResource.getOutboundFactories(connectionFactoryInterfaces);
                list.addAll(Arrays.asList(outboundFactories));
            }
        }
        return list.toArray(new JCAManagedConnectionFactory[list.size()]);
    }

    public JCAAdminObject[] getAdminObjects(ResourceAdapterModule module, String[] adminObjectInterfaces) {
        ArrayList<JCAAdminObject> list = new ArrayList<JCAAdminObject>();
        ResourceAdapter[] resourceAdapters = module.getResourceAdapterInstances();
        for (int i = 0; i < resourceAdapters.length; ++i) {
            ResourceAdapter resourceAdapter = resourceAdapters[i];
            JCAResource[] jcaResources = resourceAdapter.getJCAResourceImplementations();
            for (int j = 0; j < jcaResources.length; ++j) {
                JCAResource jcaResource = jcaResources[j];
                JCAAdminObject[] adminObjects = jcaResource.getAdminObjectInstances(adminObjectInterfaces);
                list.addAll(Arrays.asList(adminObjects));
            }
        }
        return list.toArray(new JCAAdminObject[list.size()]);
    }

    public J2EEResource[] getResources(J2EEServer server) {
        return server.getResourceInstances();
    }

    public JCAResource[] getJCAResources(J2EEServer server) {
        ArrayList<JCAResource> list = new ArrayList<JCAResource>();
        ResourceAdapterModule[] modules = server.getResourceAdapterModules();
        for (int i = 0; i < modules.length; ++i) {
            ResourceAdapterModule module = modules[i];
            ResourceAdapter[] adapters = module.getResourceAdapterInstances();
            for (int j = 0; j < adapters.length; ++j) {
                ResourceAdapter adapter = adapters[j];
                JCAResource[] resources = adapter.getJCAResourceImplementations();
                list.addAll(Arrays.asList(resources));
            }
        }
        return list.toArray(new JCAResource[list.size()]);
    }

    public JDBCResource[] getJDBCResources(J2EEServer server) {
        return new JDBCResource[0];
    }

    public JMSResource[] getJMSResources(J2EEServer server) {
        return new JMSResource[0];
    }

    public JVM[] getJavaVMs(J2EEServer server) {
        return server.getJavaVMInstances();
    }

    public SystemLog getSystemLog(JVM jvm) {
        return jvm.getSystemLog();
    }

    public J2EEModule[] getModules(J2EEApplication application) {
        return application.getModulesInstances();
    }

    public AppClientModule[] getAppClients(J2EEApplication application) {
        return application.getClientModules();
    }

    public WebModule[] getWebModules(J2EEApplication application) {
        return application.getWebModules();
    }

    public EJBModule[] getEJBModules(J2EEApplication application) {
        return application.getEJBModules();
    }

    public ResourceAdapterModule[] getRAModules(J2EEApplication application) {
        return application.getRAModules();
    }

    public JCAResource[] getJCAResources(J2EEApplication application) {
        ArrayList<JCAResource> list = new ArrayList<JCAResource>();
        ResourceAdapterModule[] modules = application.getRAModules();
        for (int i = 0; i < modules.length; ++i) {
            ResourceAdapterModule module = modules[i];
            ResourceAdapter[] adapters = module.getResourceAdapterInstances();
            for (int j = 0; j < adapters.length; ++j) {
                ResourceAdapter adapter = adapters[j];
                JCAResource[] resources = adapter.getJCAResourceImplementations();
                list.addAll(Arrays.asList(resources));
            }
        }
        return list.toArray(new JCAResource[list.size()]);
    }

    public JDBCResource[] getJDBCResources(J2EEApplication application) {
        return new JDBCResource[0];
    }

    public JMSResource[] getJMSResources(J2EEApplication application) {
        return new JMSResource[0];
    }

    public EJB[] getEJBs(EJBModule module) {
        return new EJB[0];
    }

    public Servlet[] getServlets(WebModule module) {
        return new Servlet[0];
    }

    public ResourceAdapter[] getResourceAdapters(ResourceAdapterModule module) {
        return module.getResourceAdapterInstances();
    }

    public JCAResource[] getRAResources(ResourceAdapter adapter) {
        return adapter.getJCAResourceImplementations();
    }

    public JDBCDataSource[] getDataSource(JDBCResource resource) {
        return new JDBCDataSource[0];
    }

    public JDBCDriver[] getDriver(JDBCDataSource dataSource) {
        return new JDBCDriver[0];
    }

    public JCAConnectionFactory[] getConnectionFactories(JCAResource resource) {
        return resource.getConnectionFactoryInstances();
    }

    public JCAAdminObject[] getAdminObjects(JCAResource resource) {
        return resource.getAdminObjectInstances();
    }

    public JCAManagedConnectionFactory getManagedConnectionFactory(JCAConnectionFactory factory) {
        return factory.getManagedConnectionFactoryInstance();
    }

    public Object getObject(AbstractName objectName) {
        return this.kernel.getProxyManager().createProxy(objectName, KernelManagementHelper.class.getClassLoader());
    }

    public Artifact getConfigurationNameFor(AbstractName abstractName) {
        return abstractName.getArtifact();
    }

    public String getGBeanDescription(AbstractName abstractName) {
        try {
            return this.kernel.getGBeanInfo(abstractName).getName();
        }
        catch (GBeanNotFoundException e) {
            return null;
        }
    }

    public void testLoginModule(J2EEServer server, LoginModule module, Map options) {
        options.put("org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL", this.kernel.getKernelName());
        options.put("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO", server.getServerInfo());
        if (!options.containsKey("org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER")) {
            options.put("org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER", module.getClass().getClassLoader());
        }
        module.initialize(null, null, new HashMap(), options);
    }

    public Subject testLoginModule(J2EEServer server, LoginModule module, Map options, final String username, final String password) throws LoginException {
        options.put("org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL", this.kernel.getKernelName());
        if (!options.containsKey("org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER")) {
            options.put("org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER", module.getClass().getClassLoader());
        }
        options.put("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO", server.getServerInfo());
        Subject sub = new Subject();
        CallbackHandler handler = new CallbackHandler(){

            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    Callback callback = callbacks[i];
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                        continue;
                    }
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(username);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        module.initialize(sub, handler, new HashMap(), options);
        if (module.login() && module.commit()) {
            return sub;
        }
        module.abort();
        return null;
    }

    public Object[] findByInterface(Class iface) {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(iface.getName()));
        Object[] result = new Object[set.size()];
        int i = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            result[i++] = this.kernel.getProxyManager().createProxy(name, iface.getClassLoader());
        }
        return result;
    }

    public AbstractName getNameFor(Object component) {
        return this.kernel.getAbstractNameFor(component);
    }

    public ConfigurationData[] getConfigurations(ConfigurationModuleType type, boolean includeChildModules) {
        ConfigurationManager mgr = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
        List stores = mgr.listStores();
        ArrayList<ConfigurationData> results = new ArrayList<ConfigurationData>();
        Iterator i = stores.iterator();
        while (i.hasNext()) {
            AbstractName storeName = (AbstractName)i.next();
            try {
                List infos = mgr.listConfigurations(storeName);
                Iterator j = infos.iterator();
                while (j.hasNext()) {
                    ConfigurationInfo info = (ConfigurationInfo)j.next();
                    AbstractName configuration = Configuration.getConfigurationAbstractName((Artifact)info.getConfigID());
                    if (type == null || type.getValue() == info.getType().getValue()) {
                        J2EEDeployedObject module = this.getModuleForConfiguration(info.getConfigID());
                        results.add(new ConfigurationData(info.getConfigID(), configuration, null, info.getState(), info.getType(), module == null ? null : this.kernel.getAbstractNameFor((Object)module)));
                    }
                    if (!includeChildModules || info.getType().getValue() != ConfigurationModuleType.EAR.getValue() || info.getState().toInt() != 1) continue;
                    J2EEApplication app = (J2EEApplication)this.getModuleForConfiguration(info.getConfigID());
                    if (app == null) {
                        throw new IllegalStateException("Unable to load children for J2EE Application '" + info.getConfigID() + "' (no J2EEApplication found)");
                    }
                    J2EEModule[] modules = null;
                    if (type == null) {
                        modules = app.getModulesInstances();
                    } else if (type.equals(ConfigurationModuleType.CAR)) {
                        modules = app.getClientModules();
                    } else if (type.equals(ConfigurationModuleType.EJB)) {
                        modules = app.getEJBModules();
                    } else if (type.equals(ConfigurationModuleType.RAR)) {
                        modules = app.getRAModules();
                    } else if (type.equals(ConfigurationModuleType.WAR)) {
                        modules = app.getWebModules();
                    }
                    if (modules == null) continue;
                    for (int k = 0; k < modules.length; ++k) {
                        J2EEModule module = modules[k];
                        ConfigurationModuleType moduleType = type;
                        if (moduleType == null) {
                            if (module instanceof WebModule) {
                                moduleType = ConfigurationModuleType.WAR;
                            } else if (module instanceof EJBModule) {
                                moduleType = ConfigurationModuleType.EJB;
                            } else if (module instanceof ResourceAdapterModule) {
                                moduleType = ConfigurationModuleType.RAR;
                            } else if (module instanceof AppClientModule) {
                                moduleType = ConfigurationModuleType.CAR;
                            }
                        }
                        String moduleName = type != null && type.equals(ConfigurationModuleType.WAR) ? ((WebModule)module).getWARName() : (String)this.kernel.getAbstractNameFor((Object)module).getName().get("name");
                        results.add(new ConfigurationData(info.getConfigID(), configuration, moduleName, info.getState(), moduleType, this.kernel.getAbstractNameFor((Object)module)));
                    }
                }
            }
            catch (NoSuchStoreException e) {
            }
            catch (InvalidConfigException e) {
                throw new RuntimeException("Bad configID; should never happen");
            }
        }
        Collections.sort(results);
        return results.toArray(new ConfigurationData[results.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public J2EEDeployedObject getModuleForConfiguration(Artifact configuration) {
        ConfigurationManager manager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
        Configuration config = manager.getConfiguration(configuration);
        if (config == null || !manager.isRunning(configuration)) {
            return null;
        }
        ConfigurationModuleType type = config.getModuleType();
        try {
            void var5_5;
            AbstractName result;
            if (type.equals(ConfigurationModuleType.CAR)) {
                result = config.findGBean(new AbstractNameQuery(AppClientModule.class.getName()));
            } else if (type.equals(ConfigurationModuleType.EAR)) {
                result = config.findGBean(new AbstractNameQuery(J2EEApplication.class.getName()));
            } else if (type.equals(ConfigurationModuleType.EJB)) {
                result = config.findGBean(new AbstractNameQuery(EJBModule.class.getName()));
            } else if (type.equals(ConfigurationModuleType.RAR)) {
                result = config.findGBean(new AbstractNameQuery(ResourceAdapterModule.class.getName()));
            } else if (type.equals(ConfigurationModuleType.WAR)) {
                result = config.findGBean(new AbstractNameQuery(WebModule.class.getName()));
            } else {
                return null;
            }
            return (J2EEDeployedObject)this.kernel.getProxyManager().createProxy((AbstractName)var5_5, this.getClass().getClassLoader());
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalStateException("Bad config ID: " + e.getMessage());
        }
    }

    public Object[] getGBeansImplementing(Class iface) {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(iface.getName()));
        Object[] result = (Object[])Array.newInstance(iface, set.size());
        int index = 0;
        ProxyManager mgr = this.kernel.getProxyManager();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            result[index++] = mgr.createProxy(name, iface);
        }
        return result;
    }

    public static KernelManagementHelper getRemoteKernelManager(String host, String user, String password) throws IOException {
        String uri = "jmx:rmi://" + host + "/jndi/rmi:/JMXConnector";
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        String[] credentials = new String[]{user, password};
        environment.put("jmx.remote.credentials", credentials);
        JMXServiceURL address = new JMXServiceURL("service:" + uri);
        JMXConnector jmxConnector = JMXConnectorFactory.connect(address, environment);
        MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
        KernelDelegate kernel = new KernelDelegate(mbServerConnection);
        return new KernelManagementHelper((Kernel)kernel);
    }
}

