/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.core.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.security.jaas.LoginModuleSettings;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class PropertiesLoginModuleManager {
    private ServerInfo serverInfo;
    private LoginModuleSettings loginModule;
    private Properties users = new Properties();
    private Properties groups = new Properties();
    private static final String usersKey = "usersURI";
    private static final String groupsKey = "groupsURI";
    public static final GBeanInfo GBEAN_INFO;

    public PropertiesLoginModuleManager(ServerInfo serverInfo, LoginModuleSettings loginModule) {
        this.serverInfo = serverInfo;
        this.loginModule = loginModule;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshUsers() {
        this.users.clear();
        InputStream in = null;
        try {
            try {
                in = this.serverInfo.resolve(this.getUsersURI()).toURL().openStream();
                this.users.load(in);
            }
            catch (Exception e) {
                throw new GeronimoSecurityException((Throwable)e);
            }
            Object var4_2 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        in.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshGroups() throws GeronimoSecurityException {
        this.groups.clear();
        InputStream in = null;
        try {
            try {
                in = this.serverInfo.resolve(this.getGroupsURI()).toURL().openStream();
                this.groups.load(in);
            }
            catch (Exception e) {
                throw new GeronimoSecurityException((Throwable)e);
            }
            Object var4_2 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        in.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getUsers() throws GeronimoSecurityException {
        this.users.clear();
        InputStream in = null;
        try {
            try {
                in = this.serverInfo.resolve(this.getUsersURI()).toURL().openStream();
                this.users.load(in);
            }
            catch (Exception e) {
                throw new GeronimoSecurityException((Throwable)e);
            }
            Object var4_2 = null;
            if (in == null) return this.users.keySet().toArray(new String[0]);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        in.close();
        return this.users.keySet().toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getGroups() throws GeronimoSecurityException {
        this.groups.clear();
        InputStream in = null;
        try {
            try {
                in = this.serverInfo.resolve(this.getGroupsURI()).toURL().openStream();
                this.groups.load(in);
            }
            catch (Exception e) {
                throw new GeronimoSecurityException((Throwable)e);
            }
            Object var4_2 = null;
            if (in == null) return this.groups.keySet().toArray(new String[0]);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        in.close();
        return this.groups.keySet().toArray(new String[0]);
    }

    public void addUserPrincipal(Hashtable properties) throws GeronimoSecurityException {
        if (this.users.getProperty((String)properties.get("UserName")) != null) {
            throw new GeronimoSecurityException("User principal " + properties.get("UserName") + " already exists.");
        }
        try {
            this.refreshUsers();
            this.users.setProperty((String)properties.get("UserName"), (String)properties.get("Password"));
            this.store(this.users, this.serverInfo.resolve(this.getUsersURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot add user principal: " + e.getMessage());
        }
    }

    public void removeUserPrincipal(String userPrincipal) throws GeronimoSecurityException {
        try {
            this.refreshUsers();
            this.users.remove(userPrincipal);
            this.store(this.users, this.serverInfo.resolve(this.getUsersURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot remove user principal " + userPrincipal + ": " + e.getMessage());
        }
    }

    public void updateUserPrincipal(Hashtable properties) throws GeronimoSecurityException {
        try {
            this.refreshUsers();
            this.users.setProperty((String)properties.get("UserName"), (String)properties.get("Password"));
            this.store(this.users, this.serverInfo.resolve(this.getUsersURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot add user principal: " + e.getMessage());
        }
    }

    public void addGroupPrincipal(Hashtable properties) throws GeronimoSecurityException {
        this.refreshGroups();
        if (this.groups.getProperty((String)properties.get("GroupName")) != null) {
            throw new GeronimoSecurityException("Group " + properties.get("GroupName") + " already exists.");
        }
        try {
            this.groups.setProperty((String)properties.get("GroupName"), (String)properties.get("Members"));
            this.store(this.groups, this.serverInfo.resolve(this.getGroupsURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot add group principal: " + e.getMessage());
        }
    }

    public void removeGroupPrincipal(String groupPrincipal) throws GeronimoSecurityException {
        this.refreshGroups();
        try {
            this.groups.remove(groupPrincipal);
            this.store(this.groups, this.serverInfo.resolve(this.getGroupsURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot remove group principal: " + e.getMessage());
        }
    }

    public void updateGroupPrincipal(Hashtable properties) throws GeronimoSecurityException {
        this.refreshGroups();
        try {
            this.groups.setProperty((String)properties.get("GroupName"), (String)properties.get("Members"));
            this.store(this.groups, this.serverInfo.resolve(this.getGroupsURI()).toURL());
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Cannot add group principal: " + e.getMessage());
        }
    }

    public void addToGroup(String userPrincipal, String groupPrincipal) throws GeronimoSecurityException {
        throw new GeronimoSecurityException("Not implemented for properties file security realm...");
    }

    public void removeFromGroup(String userPrincipal, String groupPrincipal) throws GeronimoSecurityException {
        throw new GeronimoSecurityException("Not implemented for properties file security realm...");
    }

    public String getPassword(String userPrincipal) throws GeronimoSecurityException {
        this.refreshUsers();
        return this.users.getProperty(userPrincipal);
    }

    public Set getGroupMembers(String groupPrincipal) throws GeronimoSecurityException {
        HashSet<String> memberSet = new HashSet<String>();
        this.groups.clear();
        this.refreshGroups();
        if (this.groups.getProperty(groupPrincipal) == null) {
            return memberSet;
        }
        String[] members = this.groups.getProperty(groupPrincipal).split(",");
        memberSet.addAll(Arrays.asList(members));
        return memberSet;
    }

    private String getUsersURI() {
        return this.loginModule.getOptions().getProperty(usersKey);
    }

    private String getGroupsURI() {
        return this.loginModule.getOptions().getProperty(groupsKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void store(Properties props, URL url) throws Exception {
        OutputStream out = null;
        try {
            try {
                URLConnection con = url.openConnection();
                con.setDoOutput(true);
                out = con.getOutputStream();
            }
            catch (Exception e) {
                if (!"file".equalsIgnoreCase(url.getProtocol()) || !(e instanceof UnknownServiceException)) throw e;
                out = new FileOutputStream(new File(url.getFile()));
            }
            props.store(out, null);
            Object var6_6 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            out.close();
            return;
        }
        catch (IOException ignored) {}
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"PropertiesLoginModuleManager", (Class)PropertiesLoginModuleManager.class);
        infoFactory.addOperation("addUserPrincipal", new Class[]{Hashtable.class});
        infoFactory.addOperation("removeUserPrincipal", new Class[]{String.class});
        infoFactory.addOperation("updateUserPrincipal", new Class[]{Hashtable.class});
        infoFactory.addOperation("getGroups");
        infoFactory.addOperation("getUsers");
        infoFactory.addOperation("updateUserPrincipal", new Class[]{Hashtable.class});
        infoFactory.addOperation("getPassword", new Class[]{String.class});
        infoFactory.addOperation("getGroupMembers", new Class[]{String.class});
        infoFactory.addOperation("addGroupPrincipal", new Class[]{Hashtable.class});
        infoFactory.addOperation("removeGroupPrincipal", new Class[]{String.class});
        infoFactory.addOperation("updateGroupPrincipal", new Class[]{Hashtable.class});
        infoFactory.addOperation("addToGroup", new Class[]{String.class, String.class});
        infoFactory.addOperation("removeFromGroup", new Class[]{String.class, String.class});
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("LoginModule", LoginModuleSettings.class, "LoginModule");
        infoFactory.setConstructor(new String[]{"ServerInfo", "LoginModule"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

