/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.core.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.core.keystore.KeyEntryInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.util.asn1.ASN1Set;
import org.apache.geronimo.util.asn1.DERObjectIdentifier;
import org.apache.geronimo.util.asn1.DEROutputStream;
import org.apache.geronimo.util.asn1.x509.X509Name;
import org.apache.geronimo.util.encoders.Base64;
import org.apache.geronimo.util.jce.PKCS10CertificationRequest;
import org.apache.geronimo.util.jce.X509Principal;
import org.apache.geronimo.util.jce.X509V1CertificateGenerator;

public class KeyStoreGBean
implements GBeanLifecycle {
    private static Log log = LogFactory.getLog((Class)KeyStoreGBean.class);
    private String keyStoreType;
    private String keyStoreProvider;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String keyPassword = new String("");
    private KeyStore keystore;
    private ServerInfo serverInfo;
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doStart() throws WaitingException, Exception {
        boolean keystoreExistsFlag;
        block12: {
            this.keystore = KeyStore.getInstance(this.keyStoreType);
            keystoreExistsFlag = true;
            InputStream is = null;
            File keyStore = this.serverInfo.resolveServer(this.keyStoreLocation);
            log.debug((Object)("loading keystore from " + keyStore));
            is = new FileInputStream(keyStore);
            this.keystore.load(is, this.keyStorePassword.toCharArray());
            Object var5_5 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block12;
            }
            catch (Exception e2) {}
            break block12;
            {
                catch (FileNotFoundException e) {
                    keystoreExistsFlag = false;
                    Object var5_6 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block12;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (!keystoreExistsFlag) {
            this.keystore.load(null, this.keyStorePassword.toCharArray());
        }
    }

    public void doStop() throws WaitingException, Exception {
    }

    public void doFail() {
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public int getKeyStoreSize() throws KeyStoreException {
        return this.keystore.size();
    }

    public KeyEntryInfo getKeyEntryInfo(String alias) throws KeyStoreException {
        KeyEntryInfo info = null;
        if (this.keystore.isCertificateEntry(alias)) {
            info = new KeyEntryInfo(alias, "trusted certificate", this.keystore.getCreationDate(alias));
        } else if (this.keystore.isKeyEntry(alias)) {
            info = new KeyEntryInfo(alias, "private key", this.keystore.getCreationDate(alias));
        } else {
            throw new KeyStoreException("invalid key entry type");
        }
        return info;
    }

    public List getKeyStoreEntries() throws KeyStoreException {
        ArrayList<KeyEntryInfo> list = new ArrayList<KeyEntryInfo>();
        Enumeration<String> aliases = this.keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            list.add(this.getKeyEntryInfo(alias));
        }
        return list;
    }

    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        Certificate[] certs = null;
        if (this.keystore.isCertificateEntry(alias)) {
            Certificate cert = this.keystore.getCertificate(alias);
            certs = new Certificate[]{cert};
        } else if (this.keystore.isKeyEntry(alias)) {
            certs = this.keystore.getCertificateChain(alias);
        } else {
            if (this.keystore.containsAlias(alias)) {
                throw new KeyStoreException("Unsupported key-store-entry, alias = " + alias);
            }
            throw new KeyStoreException("Key-store-entry alias not found, alias = " + alias);
        }
        return certs;
    }

    public String generateCSR(String alias) throws Exception {
        X509Certificate cert = (X509Certificate)this.keystore.getCertificate(alias);
        PrivateKey key = (PrivateKey)this.keystore.getKey(alias, new String("").toCharArray());
        String csr = this.generateCSR(cert, key);
        return csr;
    }

    public String generateCSR(X509Certificate cert, PrivateKey signingKey) throws Exception {
        int len;
        ASN1Set attributes;
        PublicKey publicKey;
        X509Name subject;
        String sigalg = cert.getSigAlgName();
        PKCS10CertificationRequest csr = new PKCS10CertificationRequest(sigalg, subject = new X509Name(((Object)cert.getSubjectDN()).toString()), publicKey = cert.getPublicKey(), attributes = null, signingKey);
        if (!csr.verify()) {
            throw new KeyStoreException("CSR verification failed");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DEROutputStream deros = new DEROutputStream((OutputStream)os);
        deros.writeObject((Object)csr.getDERObject());
        String b64 = new String(Base64.encode((byte[])os.toByteArray()));
        String BEGIN_CERT_REQ = "-----BEGIN CERTIFICATE REQUEST-----";
        String END_CERT_REQ = "-----END CERTIFICATE REQUEST-----";
        int CERT_REQ_LINE_LENGTH = 70;
        StringBuffer sbuf = new StringBuffer("-----BEGIN CERTIFICATE REQUEST-----").append('\n');
        for (int idx = 0; idx < b64.length(); idx += len) {
            len = idx + 70 > b64.length() ? b64.length() - idx : 70;
            String chunk = b64.substring(idx, idx + len);
            sbuf.append(chunk).append('\n');
        }
        sbuf.append("-----END CERTIFICATE REQUEST-----");
        return sbuf.toString();
    }

    public void generateKeyPair(String alias, String keyalg, Integer keysize, String sigalg, Integer validity, String cn, String ou, String o, String l, String st, String c) throws NoSuchAlgorithmException, KeyStoreException, SignatureException, InvalidKeyException, CertificateException, IOException {
        KeyPairGenerator kpgen = KeyPairGenerator.getInstance(keyalg);
        kpgen.initialize(keysize);
        KeyPair keyPair = kpgen.generateKeyPair();
        X509Certificate cert = this.generateCert(keyPair.getPublic(), keyPair.getPrivate(), sigalg, validity, cn, ou, o, l, st, c);
        this.keystore.setKeyEntry(alias, keyPair.getPrivate(), new String().toCharArray(), new Certificate[]{cert});
        this.saveKeyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveKeyStore() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        FileOutputStream os = null;
        try {
            File keyStore = this.serverInfo.resolveServer(this.keyStoreLocation);
            os = new FileOutputStream(keyStore);
            this.keystore.store(os, this.keyStorePassword.toCharArray());
            Object var4_3 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            os.close();
            return;
        }
        catch (Exception ex) {}
    }

    public X509Certificate generateCert(PublicKey publicKey, PrivateKey privateKey, String sigalg, int validity, String cn, String ou, String o, String l, String st, String c) throws SignatureException, InvalidKeyException {
        X509V1CertificateGenerator certgen = new X509V1CertificateGenerator();
        Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
        Hashtable<DERObjectIdentifier, String> attrmap = new Hashtable<DERObjectIdentifier, String>();
        if (cn != null) {
            attrmap.put(X509Principal.CN, cn);
            order.add(X509Principal.CN);
        }
        if (ou != null) {
            attrmap.put(X509Principal.OU, ou);
            order.add(X509Principal.OU);
        }
        if (o != null) {
            attrmap.put(X509Principal.O, o);
            order.add(X509Principal.O);
        }
        if (l != null) {
            attrmap.put(X509Principal.L, l);
            order.add(X509Principal.L);
        }
        if (st != null) {
            attrmap.put(X509Principal.ST, st);
            order.add(X509Principal.ST);
        }
        if (c != null) {
            attrmap.put(X509Principal.C, c);
            order.add(X509Principal.C);
        }
        X509Principal issuerDN = new X509Principal(order, attrmap);
        certgen.setIssuerDN((X509Name)issuerDN);
        long curr = System.currentTimeMillis();
        long untill = curr + (long)validity * 24L * 60L * 60L * 1000L;
        certgen.setNotBefore(new Date(curr));
        certgen.setNotAfter(new Date(untill));
        certgen.setSubjectDN((X509Name)issuerDN);
        certgen.setPublicKey(publicKey);
        certgen.setSignatureAlgorithm(sigalg);
        certgen.setSerialNumber(new BigInteger(String.valueOf(curr)));
        X509Certificate cert = certgen.generateX509Certificate(privateKey);
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importTrustedX509Certificate(String alias, String certfile) throws FileNotFoundException, CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        FileInputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", this.keyStoreProvider);
            is = new FileInputStream(certfile);
            Certificate cert = cf.generateCertificate(is);
            this.keystore.setCertificateEntry(alias, cert);
            this.saveKeyStore();
            Object var7_6 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)is).close();
            return;
        }
        catch (Exception e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importPKCS7Certificate(String alias, String certbuf) throws CertificateException, NoSuchProviderException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(certbuf.getBytes());
            this.importPKCS7Certificate(alias, is);
            Object var5_4 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)is).close();
            return;
        }
        catch (Exception e) {}
    }

    public void importPKCS7Certificate(String alias, InputStream is) throws CertificateException, NoSuchProviderException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", this.keyStoreProvider);
        Collection<? extends Certificate> certcoll = cf.generateCertificates(is);
        Certificate[] chain = new Certificate[certcoll.size()];
        Iterator<? extends Certificate> iter = certcoll.iterator();
        int i = 0;
        while (iter.hasNext()) {
            chain[i] = iter.next();
            ++i;
        }
        char[] password = this.keyPassword.toCharArray();
        this.keystore.setKeyEntry(alias, this.keystore.getKey(alias, password), password, chain);
        this.saveKeyStore();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)KeyStoreGBean.class);
        infoFactory.addAttribute("keyStoreType", String.class, true);
        infoFactory.addAttribute("keyStoreProvider", String.class, true);
        infoFactory.addAttribute("keyStoreLocation", String.class, true);
        infoFactory.addAttribute("keyStorePassword", String.class, true);
        infoFactory.addReference("serverInfo", ServerInfo.class, "GBean");
        infoFactory.addOperation("getKeyEntryInfo", new Class[]{String.class});
        infoFactory.addOperation("getKeyStoreSize");
        infoFactory.addOperation("getKeyStoreEntries");
        infoFactory.addOperation("getCertificateChain", new Class[]{String.class});
        infoFactory.addOperation("generateCSR", new Class[]{String.class});
        infoFactory.addOperation("generateKeyPair", new Class[]{String.class, String.class, Integer.class, String.class, Integer.class, String.class, String.class, String.class, String.class, String.class, String.class});
        infoFactory.addOperation("importTrustedX509Certificate", new Class[]{String.class, String.class});
        infoFactory.addOperation("importPKCS7Certificate", new Class[]{String.class, String.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

