/*
 * Decompiled with CFR 0.152.
 */
package ga.geist.jrv.types;

import ga.geist.jrv.RevoltBridge;
import ga.geist.jrv.registries.RegistryRegistry;
import ga.geist.jrv.types.Attachment;
import ga.geist.jrv.types.Channel;
import ga.geist.jrv.types.SystemMessageMap;
import ga.geist.jrv.types.User;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class Server {
    private RevoltBridge bridge;
    private String owner;
    private String[] channels;
    private SystemMessageMap systemMessageMap;
    private String name;
    private String description;
    private Attachment icon;
    private Attachment banner;
    private String id;
    private String nonce;

    public User getOwner() {
        return this.bridge.getRegistries().getUserRegistry().get(this.owner);
    }

    public Channel[] getChannels() {
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        for (int i = 0; i < this.channels.length; ++i) {
            Channel channel = this.bridge.getRegistries().getChannelRegistry().get(this.channels[i]);
            if (channel == null) continue;
            channelList.add(channel);
        }
        return channelList.toArray(new Channel[0]);
    }

    public SystemMessageMap getSystemMessageMap() {
        return this.systemMessageMap;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Attachment getIcon() {
        return this.icon;
    }

    public Attachment getBanner() {
        return this.banner;
    }

    public String getId() {
        return this.id;
    }

    public String getNonce() {
        return this.nonce;
    }

    public Server(User owner, Channel[] channels, SystemMessageMap systemMessageMap, String name, String description, Attachment icon, Attachment banner, String id, String nonce, RevoltBridge bridge) {
        this.owner = owner.getId();
        this.systemMessageMap = systemMessageMap;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.banner = banner;
        this.id = id;
        this.nonce = nonce;
        this.bridge = bridge;
        ArrayList<String> idList = new ArrayList<String>();
        for (Channel channel : channels) {
            idList.add(channel.getId());
        }
        this.channels = idList.toArray(new String[0]);
    }

    public static Server fromJSON(JSONObject object, RevoltBridge bridge) {
        RegistryRegistry registries = bridge.getRegistries();
        User owner = registries.getUserRegistry().get(object.getString("owner"));
        JSONArray jsonChannelIDs = object.getJSONArray("channels");
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        for (int i = 0; i < jsonChannelIDs.length(); ++i) {
            Channel channel = registries.getChannelRegistry().get(jsonChannelIDs.getString(i));
            if (channel == null) continue;
            channelList.add(channel);
        }
        JSONObject jsonSystemMessages = object.getJSONObject("system_messages");
        SystemMessageMap messageMap = new SystemMessageMap(registries.getChannelRegistry().get(jsonSystemMessages.optString("user_banned")), registries.getChannelRegistry().get(jsonSystemMessages.optString("user_joined")), registries.getChannelRegistry().get(jsonSystemMessages.optString("user_kicked")), registries.getChannelRegistry().get(jsonSystemMessages.optString("user_left")), bridge);
        Attachment banner = null;
        if (object.has("banner")) {
            banner = Attachment.fromJSON(object.getJSONObject("banner"));
        }
        Attachment icon = null;
        if (object.has("icon")) {
            icon = Attachment.fromJSON(object.getJSONObject("icon"));
        }
        String description = object.has("description") ? object.getString("description") : "";
        return new Server(owner, channelList.toArray(new Channel[0]), messageMap, object.getString("name"), description, icon, banner, object.getString("_id"), object.getString("nonce"), bridge);
    }
}

