/*
 * Decompiled with CFR 0.152.
 */
package ga.geist.jrv.types;

import ga.geist.jrv.RevoltBridge;
import ga.geist.jrv.types.Attachment;
import ga.geist.jrv.types.Channel;
import ga.geist.jrv.types.User;
import org.json.JSONObject;

public class Message {
    private String author;
    private String channel;
    private String id;
    private String nonce;
    private String content;
    private Attachment[] attachments;
    private RevoltBridge bridge;

    public User getAuthor() {
        return this.bridge.getRegistries().getUserRegistry().get(this.author);
    }

    public Channel getChannel() {
        return this.bridge.getRegistries().getChannelRegistry().get(this.channel);
    }

    public String getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public String getNonce() {
        return this.nonce;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public Message(User author, Channel channel, String id, String nonce, String content, Attachment[] attachments, RevoltBridge bridge) {
        this.author = author.getId();
        this.channel = channel.getId();
        this.id = id;
        this.nonce = nonce;
        this.content = content;
        this.attachments = attachments;
        this.bridge = bridge;
    }

    public static Message fromJSON(JSONObject object, RevoltBridge bridge) {
        return new Message(bridge.getRegistries().getUserRegistry().get(object.getString("author")), bridge.getRegistries().getChannelRegistry().get(object.getString("channel")), object.getString("_id"), object.optString("nonce"), object.optString("content"), Attachment.fromJSONArray(object.optJSONArray("attachments")), bridge);
    }
}

