/*
 * Decompiled with CFR 0.152.
 */
package ga.geist.jrv.types;

import ga.geist.jrv.types.AttachmentMetadata;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class Attachment {
    AttachmentMetadata metadata;
    String filename;
    String mimeType;
    long size;
    String id;
    String tag;

    public AttachmentMetadata getMetadata() {
        return this.metadata;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getSize() {
        return this.size;
    }

    public String getId() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public Attachment(AttachmentMetadata metadata, String filename, String mimeType, long size, String id, String tag) {
        this.metadata = metadata;
        this.filename = filename;
        this.mimeType = mimeType;
        this.size = size;
        this.id = id;
        this.tag = tag;
    }

    public static Attachment fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        JSONObject metaObject = object.getJSONObject("metadata");
        AttachmentMetadata metadata = new AttachmentMetadata(metaObject.getString("type"), metaObject.optInt("width"), metaObject.optInt("height"));
        return new Attachment(metadata, object.getString("filename"), object.getString("content_type"), object.getLong("size"), object.getString("_id"), object.getString("tag"));
    }

    public static Attachment[] fromJSONArray(JSONArray array) {
        if (array == null) {
            return new Attachment[0];
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (int i = 0; i < array.length(); ++i) {
            Attachment attachment = Attachment.fromJSON(array.optJSONObject(i));
            if (attachment == null) continue;
            attachments.add(attachment);
        }
        return attachments.toArray(new Attachment[0]);
    }
}

