/*
 * Decompiled with CFR 0.152.
 */
package ga.geist.jrv.packets.clientbound;

import ga.geist.jrv.RevoltBridge;
import ga.geist.jrv.SocketConnector;
import ga.geist.jrv.packets.ClientboundPacket;
import ga.geist.jrv.types.Channel;
import ga.geist.jrv.types.DirectMessage;
import ga.geist.jrv.types.GroupDM;
import ga.geist.jrv.types.Server;
import ga.geist.jrv.types.User;
import ga.geist.jrv.utils.AuthenticatedRestUtils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReadyPacket
implements ClientboundPacket {
    private void addUsers(JSONObject message, RevoltBridge bridge) {
        JSONArray users = message.getJSONArray("users");
        ArrayList<User> userList = new ArrayList<User>();
        for (int i = 0; i < users.length(); ++i) {
            userList.add(User.fromJSON(users.getJSONObject(i)));
        }
        for (User user : userList) {
            bridge.getRegistries().getUserRegistry().add(user.getId(), user);
        }
    }

    private void addChannels(JSONObject message, RevoltBridge bridge) {
        JSONArray channels = message.getJSONArray("channels");
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        ArrayList<GroupDM> gdmList = new ArrayList<GroupDM>();
        ArrayList<DirectMessage> dmList = new ArrayList<DirectMessage>();
        for (int i = 0; i < channels.length(); ++i) {
            JSONObject jSONObject = channels.getJSONObject(i);
            if (jSONObject.optString("channel_type").equals("Group")) {
                gdmList.add(GroupDM.fromJSON(jSONObject, bridge));
            } else if (jSONObject.optString("channel_type").equals("DirectMessage")) {
                dmList.add(DirectMessage.fromJSON(jSONObject, bridge));
            }
            channelList.add(new Channel(jSONObject.optString("channel_type"), jSONObject.optString("_id"), bridge));
        }
        for (Channel channel : channelList) {
            bridge.getRegistries().getChannelRegistry().add(channel.getId(), channel);
        }
        for (GroupDM groupDM : gdmList) {
            bridge.getRegistries().getGdmRegistry().add(groupDM.getId(), groupDM);
        }
        for (DirectMessage directMessage : dmList) {
            bridge.getRegistries().getDmRegistry().add(directMessage.getId(), directMessage);
        }
    }

    private void addServers(JSONObject message, RevoltBridge bridge) {
        JSONArray servers = message.getJSONArray("servers");
        ArrayList<Server> serverList = new ArrayList<Server>();
        for (int i = 0; i < servers.length(); ++i) {
            this.addUsersFromServer(servers.getJSONObject(i).optString("_id"), bridge);
            serverList.add(Server.fromJSON(servers.getJSONObject(i), bridge));
        }
        for (Server server : serverList) {
            bridge.getRegistries().getServerRegistry().add(server.getId(), server);
        }
    }

    private void addUsersFromServer(String serverId, RevoltBridge bridge) {
        String response = AuthenticatedRestUtils.getJson(bridge.getRestUrl().resolve("/servers/" + serverId + "/members"), bridge.getAuthToken());
        System.out.println(response);
        JSONObject json = new JSONObject(response);
        JSONArray users = json.getJSONArray("users");
        ArrayList<User> userList = new ArrayList<User>();
        for (int i = 0; i < users.length(); ++i) {
            userList.add(User.fromJSON(users.getJSONObject(i)));
        }
        for (User user : userList) {
            bridge.getRegistries().getUserRegistry().add(user.getId(), user);
        }
    }

    @Override
    public void pass(String stringMessage, SocketConnector client) {
        JSONObject message = new JSONObject(stringMessage);
        this.addUsers(message, client.getBridge());
        this.addChannels(message, client.getBridge());
        this.addServers(message, client.getBridge());
    }
}

