/*
 * Decompiled with CFR 0.152.
 */
package ga.geist.jrv.cores;

import ga.geist.jrv.RevoltBridge;
import ga.geist.jrv.types.Attachment;
import ga.geist.jrv.types.Channel;
import ga.geist.jrv.types.Message;
import ga.geist.jrv.types.User;
import ga.geist.jrv.utils.AuthenticatedRestUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageCore {
    private MessageCore() {
    }

    public static void sendMessage(String channelId, String contents, RevoltBridge bridge) {
        JSONObject body = new JSONObject();
        body.put("content", (Object)contents);
        body.put("nonce", (Object)MessageCore.makeNonce());
        AuthenticatedRestUtils.postJson(bridge.getRestUrl().resolve(String.format("/channels/%s/messages", channelId)), body, bridge.getAuthToken());
    }

    public static String makeNonce() {
        UUID uuid = UUID.randomUUID();
        return "JRV-MSG-" + uuid.toString().substring(0, 18);
    }

    public static Message[] fetchMessages(String channelId, Message before, RevoltBridge bridge) {
        boolean hasBefore = before == null;
        URI url = bridge.getRestUrl().resolve(hasBefore ? String.format("/channels/%s/messages", channelId) : String.format("/channels/%s/messages?before=%s", channelId, before.getId()));
        JSONArray messageArray = new JSONArray(AuthenticatedRestUtils.getJson(url, bridge.getAuthToken()));
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 0; i < messageArray.length(); ++i) {
            JSONObject messageObject = messageArray.getJSONObject(i);
            User author = bridge.getRegistries().getUserRegistry().get(messageObject.getString("author"));
            Channel channel = bridge.getRegistries().getChannelRegistry().get(messageObject.getString("channel"));
            Attachment[] attachments = Attachment.fromJSONArray(messageObject.getJSONArray("attachments"));
            Message message = new Message(author, channel, messageObject.getString("_id"), messageObject.getString("nonce"), messageObject.getString("content"), attachments, bridge);
            messages.add(message);
        }
        return messages.toArray(new Message[0]);
    }
}

