/*
 * Decompiled with CFR 0.152.
 */
package ga.geist.jrv;

import ga.geist.jrv.RevoltBridge;
import ga.geist.jrv.events.RawEvent;
import ga.geist.jrv.events.WSDroppedEvent;
import ga.geist.jrv.events.WSErrorEvent;
import ga.geist.jrv.events.WSOpenEvent;
import ga.geist.jrv.packets.ClientboundPacket;
import ga.geist.jrv.packets.serverbound.PingPacket;
import ga.geist.jrv.registries.ClientPacketRegistry;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONObject;

public class SocketConnector
extends WebSocketClient {
    private RevoltBridge bridge;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    SocketConnector(URI uri, RevoltBridge bridge) {
        super(uri);
        this.bridge = bridge;
    }

    public void onOpen(ServerHandshake handshakedata) {
        this.bridge.dispatch(new WSOpenEvent());
        this.executorService.scheduleAtFixedRate(() -> {
            PingPacket ping = new PingPacket();
            this.send(ping.toString());
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public void onMessage(String message) {
        this.bridge.dispatch(new RawEvent(message));
        String messageType = new JSONObject(message).optString("type");
        if (messageType.equals("")) {
            return;
        }
        ClientPacketRegistry s2cPacketRegistry = this.bridge.getS2cPacketRegistry();
        ClientboundPacket packet = s2cPacketRegistry.getByName(messageType);
        if (packet == null) {
            return;
        }
        packet.pass(message, this);
    }

    public void onError(Exception ex) {
        this.bridge.dispatch(new WSErrorEvent(ex));
    }

    public void onClose(int code, String reason, boolean remote) {
        this.bridge.dispatch(new WSDroppedEvent(code, reason, remote));
    }

    public RevoltBridge getBridge() {
        return this.bridge;
    }
}

