/*
 * Decompiled with CFR 0.152.
 */
package ga.geist.jrv;

import ga.geist.jrv.RevoltEventListener;
import ga.geist.jrv.SocketConnector;
import ga.geist.jrv.auth.AuthStrategy;
import ga.geist.jrv.events.Event;
import ga.geist.jrv.packets.serverbound.AuthenticatePacket;
import ga.geist.jrv.registries.ClientPacketRegistry;
import ga.geist.jrv.registries.RegistryRegistry;
import ga.geist.jrv.utils.RestUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class RevoltBridge {
    private URI restUrl;
    private List<RevoltEventListener> eventListeners = new ArrayList<RevoltEventListener>();
    private RegistryRegistry registries = new RegistryRegistry();
    private ClientPacketRegistry s2cPacketRegistry = new ClientPacketRegistry();
    private SocketConnector connector;
    private String authToken;
    private JSONObject instanceRoot;

    public RevoltBridge(URI restUrl) throws URISyntaxException {
        this.restUrl = restUrl;
        this.instanceRoot = new JSONObject(RestUtils.getJson(restUrl));
        this.connector = new SocketConnector(new URI(this.instanceRoot.getString("ws")), this);
        this.connector.connect();
    }

    public URI getRestUrl() {
        return this.restUrl;
    }

    public SocketConnector getConnector() {
        return this.connector;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getInstanceRoot() {
        return this.instanceRoot.toString(2);
    }

    public ClientPacketRegistry getS2cPacketRegistry() {
        return this.s2cPacketRegistry;
    }

    public void registerEventListener(RevoltEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void dispatch(Event event) {
        for (RevoltEventListener revoltEventListener : this.eventListeners) {
            revoltEventListener.onEvent(event, this);
        }
    }

    public RegistryRegistry getRegistries() {
        return this.registries;
    }

    public void authenticate(AuthStrategy strategy) {
        this.authToken = strategy.getBotToken();
        AuthenticatePacket authPacket = new AuthenticatePacket(this.authToken);
        this.connector.send(authPacket.toString());
    }
}

