/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.hibernate;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.avalon.HibernateService;
import org.apache.avalon.framework.component.Component;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.hibernate.PersistenceHelper;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;

public class PersistenceHelperHibernateServiceImpl
extends AbstractManager
implements PersistenceHelper,
Component {
    private static Log log;
    protected HibernateService hibernateService;
    private Session session;
    protected Transaction transaction;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.hibernate.PersistenceHelperHibernateServiceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void removeEntity(SecurityEntity entity) throws DataBackendException {
        try {
            this.session = this.retrieveSession();
            this.transaction = this.session.beginTransaction();
            this.session.delete((Object)entity);
            this.transaction.commit();
        }
        catch (HibernateException he) {
            try {
                this.transaction.rollback();
            }
            catch (HibernateException hibernateException) {
                // empty catch block
            }
            throw new DataBackendException("Problem removing entity:" + he.getMessage(), (Throwable)he);
        }
    }

    public void updateEntity(SecurityEntity entity) throws DataBackendException {
        try {
            this.session = this.retrieveSession();
            this.transaction = this.session.beginTransaction();
            this.session.update((Object)entity);
            this.transaction.commit();
        }
        catch (HibernateException he) {
            try {
                if (this.transaction != null) {
                    this.transaction.rollback();
                }
                if (he.getMessage().indexOf("Another object was associated with this id") <= -1) {
                    throw new DataBackendException("updateEntity(" + entity + ")", (Throwable)he);
                }
                this.session.close();
                this.updateEntity(entity);
            }
            catch (HibernateException hibernateException) {
                // empty catch block
            }
        }
    }

    public void addEntity(SecurityEntity entity) throws DataBackendException {
        try {
            this.session = this.retrieveSession();
            this.transaction = this.session.beginTransaction();
            this.session.save((Object)entity);
            this.transaction.commit();
        }
        catch (HibernateException he) {
            try {
                this.transaction.rollback();
            }
            catch (HibernateException hibernateException) {
                // empty catch block
            }
            throw new DataBackendException("addEntity(s,name)", (Throwable)he);
        }
    }

    public Session retrieveSession() throws HibernateException {
        if (this.session == null || !this.session.isConnected() && !this.session.isOpen()) {
            this.session = this.getHibernateService().openSession();
        }
        return this.session;
    }

    public void setHibernateService(HibernateService hibernateService) {
        this.hibernateService = hibernateService;
    }

    public HibernateService getHibernateService() throws HibernateException {
        if (this.hibernateService == null) {
            this.hibernateService = (HibernateService)this.resolve(HibernateService.ROLE);
        }
        return this.hibernateService;
    }

    public void dispose() {
        this.release(this.hibernateService);
        super.dispose();
    }
}

