/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.hibernate;

import java.util.Collection;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.hibernate.PersistenceHelper;
import org.apache.fulcrum.security.spi.AbstractUserManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;

public class HibernateUserManagerImpl
extends AbstractUserManager {
    private static Log log;
    private PersistenceHelper persistenceHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.hibernate.HibernateUserManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean checkExists(String userName) throws DataBackendException {
        List users = null;
        userName = userName.toLowerCase();
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.User");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            users = session.find(stringBuffer.append(clazz.getName()).append(" su where su.name=?").toString(), (Object)userName, (Type)Hibernate.STRING);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving user information", (Throwable)e);
        }
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + userName + "'");
        }
        return users.size() == 1;
    }

    public User getUser(String userName) throws UnknownEntityException, DataBackendException {
        List users = null;
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.User");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            users = session.find(stringBuffer.append(clazz.getName()).append(" su where su.name=?").toString(), (Object)userName.toLowerCase(), (Type)Hibernate.STRING);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving user information", (Throwable)e);
        }
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + userName + "'");
        }
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        throw new UnknownEntityException("Unknown user '" + userName + "'");
    }

    public UserSet getAllUsers() throws DataBackendException {
        UserSet userSet = new UserSet();
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.User");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            List users = session.find(stringBuffer.append(clazz.getName()).toString());
            userSet.add((Collection)users);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving all users", (Throwable)e);
        }
        return userSet;
    }

    public void removeUser(User user) throws DataBackendException, UnknownEntityException {
        this.getPersistenceHelper().removeEntity((SecurityEntity)user);
    }

    public User persistNewUser(User user) throws DataBackendException {
        this.getPersistenceHelper().addEntity((SecurityEntity)user);
        return user;
    }

    public void saveUser(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        userExists = this.checkExists(user);
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user + "'");
        }
        this.getPersistenceHelper().updateEntity((SecurityEntity)user);
    }

    public PersistenceHelper getPersistenceHelper() throws DataBackendException {
        if (this.persistenceHelper == null) {
            this.persistenceHelper = (PersistenceHelper)this.resolve(PersistenceHelper.ROLE);
        }
        return this.persistenceHelper;
    }

    public User getUserById(Object id) throws DataBackendException, UnknownEntityException {
        User user = null;
        if (id != null) {
            try {
                List users;
                Session session = this.getPersistenceHelper().retrieveSession();
                StringBuffer stringBuffer = new StringBuffer("from ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.User");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((users = session.find(stringBuffer.append(clazz.getName()).append(" su where su.id=?").toString(), id, (Type)Hibernate.LONG)).size() == 0) {
                    throw new UnknownEntityException("Could not find user by id " + id);
                }
                user = (User)users.get(0);
            }
            catch (HibernateException e) {
                throw new DataBackendException("Error retriving user information", (Throwable)e);
            }
        }
        return user;
    }
}

