/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.hibernate;

import java.util.Collection;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.hibernate.PersistenceHelper;
import org.apache.fulcrum.security.spi.AbstractPermissionManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class HibernatePermissionManagerImpl
extends AbstractPermissionManager {
    private static Log log;
    private PersistenceHelper persistenceHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.hibernate.HibernatePermissionManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public PermissionSet getAllPermissions() throws DataBackendException {
        PermissionSet permissionSet = new PermissionSet();
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Permission");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            List permissions = session.find(stringBuffer.append(clazz.getName()).toString());
            permissionSet.add((Collection)permissions);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving permission information", (Throwable)e);
        }
        return permissionSet;
    }

    public synchronized void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        permissionExists = this.checkExists(permission);
        if (permissionExists) {
            permission.setName(name);
            this.getPersistenceHelper().updateEntity((SecurityEntity)permission);
            return;
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public boolean checkExists(String permissionName) throws DataBackendException {
        List permissions;
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Permission");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            permissions = session.find(stringBuffer.append(clazz.getName()).append(" sp where sp.name=?").toString(), (Object)permissionName, (Type)Hibernate.STRING);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving permission information", (Throwable)e);
        }
        if (permissions.size() > 1) {
            throw new DataBackendException("Multiple permissions with same name '" + permissionName + "'");
        }
        return permissions.size() == 1;
    }

    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        permissionExists = this.checkExists(permission);
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission + "'");
        }
        this.getPersistenceHelper().removeEntity((SecurityEntity)permission);
    }

    protected synchronized Permission persistNewPermission(Permission permission) throws DataBackendException {
        this.getPersistenceHelper().addEntity((SecurityEntity)permission);
        return permission;
    }

    public PersistenceHelper getPersistenceHelper() throws DataBackendException {
        if (this.persistenceHelper == null) {
            this.persistenceHelper = (PersistenceHelper)this.resolve(PersistenceHelper.ROLE);
        }
        return this.persistenceHelper;
    }

    public Permission getPermissionById(Object id) throws DataBackendException, UnknownEntityException {
        Permission permission = null;
        if (id != null) {
            try {
                List permissions;
                Session session = this.getPersistenceHelper().retrieveSession();
                StringBuffer stringBuffer = new StringBuffer("from ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Permission");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((permissions = session.find(stringBuffer.append(clazz.getName()).append(" sp where sp.id=?").toString(), id, (Type)Hibernate.LONG)).size() == 0) {
                    throw new UnknownEntityException("Could not find permission by id " + id);
                }
                permission = (Permission)permissions.get(0);
            }
            catch (HibernateException e) {
                throw new DataBackendException("Error retriving permission information", (Throwable)e);
            }
        }
        return permission;
    }
}

