/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.hibernate;

import java.util.Collection;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.hibernate.PersistenceHelper;
import org.apache.fulcrum.security.spi.AbstractGroupManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class HibernateGroupManagerImpl
extends AbstractGroupManager {
    private static Log log;
    private PersistenceHelper persistenceHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.hibernate.HibernateGroupManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Group getGroupByName(String name) throws DataBackendException, UnknownEntityException {
        Group group = null;
        try {
            List groups;
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Group");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((groups = session.find(stringBuffer.append(clazz.getName()).append(" g where g.name=?").toString(), (Object)name.toLowerCase(), (Type)Hibernate.STRING)).size() == 0) {
                throw new UnknownEntityException("Could not find group" + name);
            }
            group = (Group)groups.get(0);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving group information", (Throwable)e);
        }
        return group;
    }

    public GroupSet getAllGroups() throws DataBackendException {
        GroupSet groupSet = new GroupSet();
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Group");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            List groups = session.find(stringBuffer.append(clazz.getName()).toString());
            groupSet.add((Collection)groups);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving group information", (Throwable)e);
        }
        return groupSet;
    }

    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        this.getPersistenceHelper().removeEntity((SecurityEntity)group);
    }

    public synchronized void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        groupExists = this.checkExists(group);
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group + "'");
        }
        group.setName(name);
        this.getPersistenceHelper().updateEntity((SecurityEntity)group);
    }

    public boolean checkExists(String groupName) throws DataBackendException {
        List groups;
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Group");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            groups = session.find(stringBuffer.append(clazz.getName()).append(" sg where sg.name=?").toString(), (Object)groupName, (Type)Hibernate.STRING);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving user information", (Throwable)e);
        }
        if (groups.size() > 1) {
            throw new DataBackendException("Multiple groups with same name '" + groupName + "'");
        }
        return groups.size() == 1;
    }

    protected synchronized Group persistNewGroup(Group group) throws DataBackendException {
        this.getPersistenceHelper().addEntity((SecurityEntity)group);
        return group;
    }

    public PersistenceHelper getPersistenceHelper() throws DataBackendException {
        if (this.persistenceHelper == null) {
            this.persistenceHelper = (PersistenceHelper)this.resolve(PersistenceHelper.ROLE);
        }
        return this.persistenceHelper;
    }

    public Group getGroupById(Object id) throws DataBackendException, UnknownEntityException {
        Group group = null;
        if (id != null) {
            try {
                List groups;
                Session session = this.getPersistenceHelper().retrieveSession();
                StringBuffer stringBuffer = new StringBuffer("from ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Group");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((groups = session.find(stringBuffer.append(clazz.getName()).append(" sr where sr.id=?").toString(), id, (Type)Hibernate.LONG)).size() == 0) {
                    throw new UnknownEntityException("Could not find group by id " + id);
                }
                group = (Group)groups.get(0);
            }
            catch (HibernateException e) {
                throw new DataBackendException("Error retriving group information", (Throwable)e);
            }
        }
        return group;
    }
}

