/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.quartz.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.quartz.QuartzScheduler;
import org.apache.fulcrum.quartz.listener.ServiceableJobListener;
import org.apache.fulcrum.quartz.listener.impl.ServiceableJobListenerWrapper;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class DefaultQuartzScheduler
implements QuartzScheduler,
Configurable,
Serviceable,
Disposable,
Initializable,
ThreadSafe {
    private ServiceableJobListener wrapper;
    private ServiceManager manager;
    private String globalJobListenerClassName;
    protected Log logger;
    private Scheduler scheduler;
    private Configuration jobDetailsConf;
    private Configuration triggersConf;
    private Configuration scheduledJobs;
    private Map jobDetailsMap;
    private Map triggersMap;
    static /* synthetic */ Class class$0;

    public DefaultQuartzScheduler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.quartz.impl.DefaultQuartzScheduler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((String)clazz.getName());
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.jobDetailsConf = conf.getChild("jobDetails").getChild("list");
        this.triggersConf = conf.getChild("triggers").getChild("list");
        this.scheduledJobs = conf.getChild("scheduledJobs");
        Configuration child = conf.getChild("globalJobListener", false);
        if (child != null) {
            this.globalJobListenerClassName = conf.getChild("globalJobListener").getAttribute("className");
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        StdSchedulerFactory schedFact = new StdSchedulerFactory();
        try {
            this.scheduler = schedFact.getScheduler();
        }
        catch (SchedulerException e) {
            throw new ServiceException("Error composing scheduler instance", (Throwable)e);
        }
    }

    public void initialize() throws Exception {
        String key;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        DefaultConfigurationSerializer serializer = new DefaultConfigurationSerializer();
        try {
            String xmlAsString = serializer.serialize(this.jobDetailsConf);
            List jobDetails = (List)xstream.fromXML(xmlAsString);
            this.jobDetailsMap = new HashMap(jobDetails.size());
            Iterator i = jobDetails.iterator();
            while (i.hasNext()) {
                JobDetail jobDetail = (JobDetail)i.next();
                this.jobDetailsMap.put(jobDetail.getFullName(), jobDetail);
            }
            xmlAsString = serializer.serialize(this.triggersConf);
            List triggers = (List)xstream.fromXML(xmlAsString);
            this.triggersMap = new HashMap(triggers.size());
            Iterator i2 = triggers.iterator();
            while (i2.hasNext()) {
                Trigger trigger = (Trigger)i2.next();
                this.triggersMap.put(trigger.getFullName(), trigger);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        Iterator iter = this.jobDetailsMap.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            JobDetail jobDetail = (JobDetail)this.jobDetailsMap.get(key);
            this.logger.debug((Object)("Adding job detail [" + jobDetail + "] to scheduler"));
            this.scheduler.addJob(jobDetail, true);
        }
        if (this.globalJobListenerClassName != null) {
            JobListener configuredjobListener = (JobListener)Class.forName(this.globalJobListenerClassName).newInstance();
            this.wrapper = new ServiceableJobListenerWrapper(configuredjobListener);
            this.wrapper.service(this.manager);
            this.scheduler.addGlobalJobListener((JobListener)this.wrapper);
        }
        iter = this.triggersMap.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            Trigger trigger = (Trigger)this.triggersMap.get(key);
            if (!(trigger instanceof CronTrigger) || !(trigger.getJobGroup() != null & trigger.getJobName() != null)) continue;
            CronTrigger triggerToSchedule = new CronTrigger(trigger.getName(), trigger.getGroup(), trigger.getJobName(), trigger.getJobGroup(), ((CronTrigger)trigger).getCronExpression());
            this.logger.debug((Object)("Scheduling trigger [" + triggerToSchedule.getFullName() + "] for  job [" + triggerToSchedule.getFullJobName() + "] using cron " + triggerToSchedule.getCronExpression()));
            triggerToSchedule.setDescription(trigger.getDescription());
            this.scheduler.scheduleJob((Trigger)triggerToSchedule);
        }
        this.scheduler.start();
        this.logger.debug((Object)"Quartz scheduler started !");
    }

    public void dispose() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            this.logger.warn((Object)"Problem shuting down scheduler ", (Throwable)e);
        }
        this.wrapper.dispose();
        this.scheduler = null;
        this.manager = null;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Map getJobDetailsMap() {
        return this.jobDetailsMap;
    }

    public Map getTriggersMap() {
        return this.triggersMap;
    }
}

