/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.osworkflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.query.WorkflowQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WorkflowInstance {
    private Workflow workflow;
    private long id;

    public long getId() {
        return this.id;
    }

    private WorkflowInstance() {
    }

    public WorkflowInstance(Workflow workflow, long id) {
        this.workflow = workflow;
        this.id = id;
    }

    public boolean canInitialize(String workflowName, int initialStep) throws WorkflowException {
        return this.workflow.canInitialize(workflowName, initialStep);
    }

    public boolean canModifyEntryState(int step) throws WorkflowException {
        return this.workflow.canModifyEntryState(this.getId(), step);
    }

    public void changeEntryState(int entryState) throws WorkflowException {
        this.workflow.changeEntryState(this.getId(), entryState);
    }

    public void doAction(int actionId, Map inputs) throws InvalidInputException, WorkflowException {
        this.workflow.doAction(this.getId(), actionId, inputs);
    }

    public boolean equals(Object obj) {
        return this.workflow.equals(obj);
    }

    public void executeTriggerFunction(int triggerId) throws WorkflowException {
        this.workflow.executeTriggerFunction(this.getId(), triggerId);
    }

    public int[] getAvailableActions(Map inputs) throws WorkflowException {
        return this.workflow.getAvailableActions(this.getId(), inputs);
    }

    public List getCurrentSteps() throws WorkflowException {
        return this.workflow.getCurrentSteps(this.getId());
    }

    public int getEntryState() throws WorkflowException {
        return this.workflow.getEntryState(this.getId());
    }

    public List getHistorySteps() throws WorkflowException {
        return this.workflow.getHistorySteps(this.getId());
    }

    public PropertySet getPropertySet() throws WorkflowException {
        return this.workflow.getPropertySet(this.getId());
    }

    public List getSecurityPermissions() throws WorkflowException {
        return this.workflow.getSecurityPermissions(this.getId());
    }

    public WorkflowDescriptor getWorkflowDescriptor() throws WorkflowException {
        return this.workflow.getWorkflowDescriptor(this.getWorkflowName());
    }

    public String getWorkflowName() throws WorkflowException {
        return this.workflow.getWorkflowName(this.getId());
    }

    public int hashCode() {
        return this.workflow.hashCode();
    }

    public List query(WorkflowQuery query) throws WorkflowException {
        return this.workflow.query(query);
    }

    public String toString() {
        return this.workflow.toString();
    }

    public List getAllAvailableActions() throws WorkflowException {
        ArrayList<ActionDescriptor> actions = new ArrayList<ActionDescriptor>();
        int[] actionIds = this.workflow.getAvailableActions(this.getId(), Collections.EMPTY_MAP);
        for (int i = 0; i < actionIds.length; ++i) {
            ActionDescriptor action = this.getWorkflowDescriptor().getAction(actionIds[i]);
            actions.add(action);
        }
        return actions;
    }
}

