/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.naming.NamingService;

public class DefaultNamingService
extends AbstractLogEnabled
implements NamingService,
Configurable,
Initializable,
ThreadSafe {
    private static Hashtable contextPropsList = null;
    private Hashtable initialContexts = new Hashtable();

    public Context getContext(String contextName) {
        Properties contextProps = null;
        contextProps = contextPropsList.containsKey(contextName) ? (Properties)contextPropsList.get(contextName) : new Properties();
        try {
            return new InitialContext(contextProps);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        contextPropsList = new Hashtable();
        Configuration[] keys = conf.getChildren();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                String contextName = keys[i].getName();
                Properties contextProps = DefaultNamingService.toProperties(Parameters.fromConfiguration((Configuration)keys[i]));
                contextPropsList.put(contextName, contextProps);
            }
        }
    }

    private static Properties toProperties(Parameters params) {
        Properties properties = new Properties();
        String[] names = params.getNames();
        for (int i = 0; i < names.length; ++i) {
            properties.setProperty(names[i], params.getParameter(names[i], ""));
        }
        return properties;
    }

    public void initialize() throws Exception {
        try {
            Enumeration contextPropsKeys = contextPropsList.keys();
            while (contextPropsKeys.hasMoreElements()) {
                String key = (String)contextPropsKeys.nextElement();
                Properties contextProps = (Properties)contextPropsList.get(key);
                InitialContext context = new InitialContext(contextProps);
                this.initialContexts.put(key, context);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to initialize JDNI contexts!", (Throwable)e);
            throw new Exception("Failed to initialize JDNI contexts!", e);
        }
    }
}

