/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.factory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.factory.Factory;
import org.apache.fulcrum.factory.FactoryException;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.factory.utils.ObjectInputStreamForContext;

public class DefaultFactoryService
extends AbstractLogEnabled
implements FactoryService,
Configurable,
Initializable {
    protected boolean initialized = false;
    private static final String CLASS_LOADER = "classloader";
    private static final String OBJECT_FACTORY = "object-factory";
    protected static final String DEFAULT_FACTORY = "default";
    private static HashMap primitiveClasses;
    private String[] loaderNames;
    private ArrayList classLoaders;
    private HashMap objectFactories;

    protected static Class getPrimitiveClass(String type) {
        return (Class)primitiveClasses.get(type);
    }

    public DefaultFactoryService() {
        primitiveClasses = new HashMap(8);
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.classLoaders = new ArrayList();
        this.objectFactories = new HashMap();
    }

    public Object getInstance(String className) throws FactoryException {
        if (className == null) {
            throw new FactoryException("Missing String className");
        }
        Factory factory = this.getFactory(className);
        if (factory == null) {
            Class clazz;
            try {
                clazz = this.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                throw new FactoryException("Instantiation failed for class " + className, x);
            }
            return this.getInstance(clazz);
        }
        return factory.getInstance();
    }

    public Object getInstance(String className, ClassLoader loader) throws FactoryException {
        Factory factory = this.getFactory(className);
        if (factory == null) {
            if (loader != null) {
                Class clazz;
                try {
                    clazz = this.loadClass(className, loader);
                }
                catch (ClassNotFoundException x) {
                    throw new FactoryException("Instantiation failed for class " + className, x);
                }
                return this.getInstance(clazz);
            }
            return this.getInstance(className);
        }
        return factory.getInstance(loader);
    }

    public Object getInstance(String className, Object[] params, String[] signature) throws FactoryException {
        Factory factory = this.getFactory(className);
        if (factory == null) {
            Class clazz;
            try {
                clazz = this.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                throw new FactoryException("Instantiation failed for class " + className, x);
            }
            return this.getInstance(clazz, params, signature);
        }
        return factory.getInstance(params, signature);
    }

    public Object getInstance(String className, ClassLoader loader, Object[] params, String[] signature) throws FactoryException {
        Factory factory = this.getFactory(className);
        if (factory == null) {
            if (loader != null) {
                Class clazz;
                try {
                    clazz = this.loadClass(className, loader);
                }
                catch (ClassNotFoundException x) {
                    throw new FactoryException("Instantiation failed for class " + className, x);
                }
                return this.getInstance(clazz, params, signature);
            }
            return this.getInstance(className, params, signature);
        }
        return factory.getInstance(loader, params, signature);
    }

    public boolean isLoaderSupported(String className) throws FactoryException {
        Factory factory = this.getFactory(className);
        return factory != null ? factory.isLoaderSupported() : true;
    }

    public Object getInstance(Class clazz) throws FactoryException {
        try {
            return clazz.newInstance();
        }
        catch (Exception x) {
            throw new FactoryException("Instantiation failed for " + clazz.getName(), x);
        }
    }

    protected Object getInstance(Class clazz, Object[] params, String[] signature) throws FactoryException {
        try {
            Class[] sign = this.getSignature(clazz, params, signature);
            return clazz.getConstructor(sign).newInstance(params);
        }
        catch (Exception x) {
            throw new FactoryException("Instantiation failed for " + clazz.getName(), x);
        }
    }

    public Class[] getSignature(Class clazz, Object[] params, String[] signature) throws ClassNotFoundException {
        if (signature != null) {
            ClassLoader loader = clazz.getClassLoader();
            Class[] sign = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                sign[i] = DefaultFactoryService.getPrimitiveClass(signature[i]);
                if (sign[i] != null) continue;
                if (loader != null) {
                    sign[i] = loader.loadClass(signature[i]);
                    ClassLoader tempLoader = sign[i].getClassLoader();
                    if (params[i] == null || tempLoader == null || tempLoader.equals(params[i].getClass().getClassLoader())) continue;
                    params[i] = this.switchObjectContext(params[i], loader);
                    continue;
                }
                sign[i] = this.loadClass(signature[i]);
            }
            return sign;
        }
        return null;
    }

    protected Object switchObjectContext(Object object, ClassLoader loader) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(object);
            out.flush();
        }
        catch (Exception x) {
            return object;
        }
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ObjectInputStreamForContext in = new ObjectInputStreamForContext(bin, loader);
            return in.readObject();
        }
        catch (Exception x) {
            return object;
        }
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            return loader != null ? loader.loadClass(className) : Class.forName(className);
        }
        catch (ClassNotFoundException x) {
            Iterator i = ((AbstractList)this.classLoaders).iterator();
            while (i.hasNext()) {
                try {
                    return ((ClassLoader)i.next()).loadClass(className);
                }
                catch (ClassNotFoundException xx) {
                }
            }
            throw x;
        }
    }

    protected Class loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return loader != null ? loader.loadClass(className) : this.loadClass(className);
    }

    protected Factory getFactory(String className) throws FactoryException {
        HashMap factories = this.objectFactories;
        Object factory = factories.get(className);
        if (factory == null) {
            factory = factories.get(DEFAULT_FACTORY);
        }
        if (factory != null) {
            if (factory instanceof String) {
                try {
                    factory = (Factory)this.getInstance((String)factory);
                    ((Factory)factory).init(className);
                }
                catch (FactoryException x) {
                    throw x;
                }
                catch (ClassCastException x) {
                    throw new FactoryException("Incorrect factory " + (String)factory + " for class " + className, x);
                }
                factories = (HashMap)factories.clone();
                factories.put(className, factory);
                this.objectFactories = factories;
            }
            return (Factory)factory;
        }
        return null;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration factories;
        Configuration[] loaders = conf.getChildren(CLASS_LOADER);
        if (loaders != null) {
            this.loaderNames = new String[loaders.length];
            for (int i = 0; i < loaders.length; ++i) {
                this.loaderNames[i] = loaders[i].getValue();
            }
        }
        if ((factories = conf.getChild(OBJECT_FACTORY, false)) != null) {
            Configuration[] nameVal = factories.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String key = nameVal[i].getName();
                String factory = nameVal[i].getValue();
                this.objectFactories.put(key, factory);
            }
        }
    }

    public void initialize() throws Exception {
        if (this.loaderNames != null) {
            for (int i = 0; i < this.loaderNames.length; ++i) {
                try {
                    this.classLoaders.add(this.loadClass(this.loaderNames[i]).newInstance());
                    continue;
                }
                catch (Exception x) {
                    throw new Exception("No such class loader '" + this.loaderNames[i] + "' for DefaultFactoryService", x);
                }
            }
            this.loaderNames = null;
        }
    }
}

