/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.utils.NPC;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import fr.pulsedev.api.Interfaces.CustomPlugin;
import fr.pulsedev.api.Player.ApiPlayer;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.v1_15_R1.EntityHuman;
import net.minecraft.server.v1_15_R1.EntityPlayer;
import net.minecraft.server.v1_15_R1.MinecraftServer;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_15_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_15_R1.PlayerConnection;
import net.minecraft.server.v1_15_R1.PlayerInteractManager;
import net.minecraft.server.v1_15_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.entity.Player;

public class NPC
extends EntityPlayer {
    private final EntityPlayer npc;
    private String name = "Default Name";
    private UUID uuid = UUID.fromString("668902fb-25a6-440a-80f3-f626aa9430fc");
    private GameProfile gameProfile = new GameProfile(UUID.fromString("668902fb-25a6-440a-80f3-f626aa9430fc"), "Default Name");
    private MinecraftServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
    private WorldServer worldServer = ((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle();
    private PlayerInteractManager playerInteractManager = new PlayerInteractManager(((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle());
    private String skin;
    private String signature;
    private final CustomPlugin<?> plugin;

    public NPC(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile, PlayerInteractManager playerInteractManager, CustomPlugin<?> plugin) {
        super(minecraftserver, worldserver, gameprofile, playerInteractManager);
        this.npc = new EntityPlayer(minecraftserver, worldserver, gameprofile, playerInteractManager);
        this.plugin = plugin;
    }

    public NPC(CustomPlugin<?> plugin) {
        this((MinecraftServer)((CraftServer)Bukkit.getServer()).getServer(), ((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle(), new GameProfile(UUID.fromString("668902fb-25a6-440a-80f3-f626aa9430fc"), "Default Name"), new PlayerInteractManager(((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle()), plugin);
    }

    public NPC(GameProfile gameProfile, CustomPlugin<?> plugin) {
        this((MinecraftServer)((CraftServer)Bukkit.getServer()).getServer(), ((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle(), gameProfile, new PlayerInteractManager(((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle()), plugin);
        this.gameProfile = gameProfile;
        this.name = gameProfile.getName();
        this.uuid = gameProfile.getId();
    }

    public NPC(String name, CustomPlugin<?> plugin) {
        this((MinecraftServer)((CraftServer)Bukkit.getServer()).getServer(), ((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle(), new GameProfile(UUID.fromString("668902fb-25a6-440a-80f3-f626aa9430fc"), name), new PlayerInteractManager(((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle()), plugin);
        this.name = name;
    }

    public NPC(UUID uuid, CustomPlugin<?> plugin) {
        this((MinecraftServer)((CraftServer)Bukkit.getServer()).getServer(), ((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle(), new GameProfile(uuid, "Default Name"), new PlayerInteractManager(((CraftWorld)Objects.requireNonNull(Bukkit.getServer().getWorld(((CraftServer)Bukkit.getServer()).getServer().getWorld()))).getHandle()), plugin);
        this.uuid = uuid;
    }

    public void spawn(ApiPlayer player) {
        PlayerConnection connection = player.getHandle().playerConnection;
        connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{this}));
        connection.sendPacket((Packet)new PacketPlayOutNamedEntitySpawn((EntityHuman)this));
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin.getInstance(), () -> connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{this.getNPC()})), 10L);
    }

    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
        this.name = gameProfile.getName();
        this.uuid = gameProfile.getId();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setMinecraftServer(MinecraftServer minecraftServer) {
        this.minecraftServer = minecraftServer;
    }

    public void setWorldServer(WorldServer worldServer) {
        this.worldServer = worldServer;
    }

    public void setPlayerInteractManager(PlayerInteractManager playerInteractManager) {
        this.playerInteractManager = playerInteractManager;
    }

    public void setSkin(String skin, String signature) {
        this.skin = skin;
        this.signature = signature;
        this.gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", skin, signature));
    }

    public void setSkin(String skin) {
        this.skin = skin;
        this.gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", skin, this.getSignature()));
    }

    public void setSignature(String signature) {
        this.signature = signature;
        this.gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", this.getSkin(), signature));
    }

    @Nullable
    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public WorldServer getWorldServer() {
        return this.worldServer;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public EntityPlayer getNpc() {
        return this.npc;
    }

    public PlayerInteractManager getPlayerInteractManager() {
        return this.playerInteractManager;
    }

    public String getSkin() {
        return this.skin;
    }

    public String getSignature() {
        return this.signature;
    }

    public NPC getNPC() {
        return this;
    }

    public Player getEntityPlayer() {
        return this.getBukkitEntity().getPlayer();
    }
}

