/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.utils.Lang;

import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class MessageConfiguration {
    private final TreeMap<String, String> replacement;
    private final String id;

    public MessageConfiguration(String id, @Nullable TreeMap<String, String> replacement) {
        this.id = id;
        this.replacement = replacement;
    }

    public void addReplacement(String from, String to) {
        if (this.isAlreadyIn(from)) {
            from = this.getNewString(from);
        }
        assert (this.replacement != null);
        this.replacement.put(from, to);
    }

    public void removeReplacement(String from) {
        assert (this.replacement != null);
        this.replacement.remove(from);
    }

    public void changeReplacement(String of, String by) {
        assert (this.replacement != null);
        this.replacement.remove(of);
        this.addReplacement(of, by);
    }

    public String getNewString(String base) {
        int i;
        StringBuilder newKey = new StringBuilder(base);
        for (i = 0; this.isAlreadyIn(base) && i < 5; ++i) {
            newKey.append("_");
        }
        if (i == 5) {
            throw new ArrayIndexOutOfBoundsException("You've reach maximum for this key !  KEY =" + base);
        }
        return newKey.toString();
    }

    public boolean isAlreadyIn(String toVerify) {
        assert (this.replacement != null);
        return !this.replacement.containsKey(toVerify);
    }

    public String getReplacement(String of) {
        assert (this.replacement != null);
        return this.replacement.get(of);
    }

    public TreeMap<String, String> getListOfReplacement() {
        return this.replacement;
    }

    public String getId() {
        return this.id;
    }
}

