/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.utils.Lang;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Locate {
    private final Plugin plugin;
    private final HashMap<String, FileConfiguration> locations;
    private final File[] locationFiles;

    public HashMap<String, FileConfiguration> getLocations() {
        return this.locations;
    }

    public File[] getLocationFiles() {
        return this.locationFiles;
    }

    public Locate(@NotNull Plugin plugin, @Nullable HashMap<String, FileConfiguration> locations, @Nullable File[] locationFiles) {
        this.plugin = plugin;
        this.locations = locations;
        this.locationFiles = locationFiles;
    }

    public Locate(@NotNull Plugin plugin) {
        this(plugin, new HashMap<String, FileConfiguration>(), new File[0]);
    }

    public void register() {
        File locationFolder = new File(this.plugin.getDataFolder().getPath() + File.pathSeparator + "location");
        if (!locationFolder.exists()) {
            locationFolder.mkdir();
        }
        FilenameFilter ymlFilter = (dir, name) -> name.endsWith(".yml");
        File[] fileList = locationFolder.listFiles(ymlFilter);
        assert (fileList != null);
        for (File file : fileList) {
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            assert (this.locations != null);
            this.locations.put(file.getName().replace(".yml", ""), (FileConfiguration)configuration);
        }
    }

    public Locate register(@Nullable String ignored) {
        File locationFolder = new File(this.plugin.getDataFolder().getPath() + File.pathSeparator + "location");
        if (!locationFolder.exists()) {
            locationFolder.mkdir();
        }
        FilenameFilter ymlFilter = (dir, name) -> name.endsWith(".yml");
        File[] fileList = locationFolder.listFiles(ymlFilter);
        assert (fileList != null);
        for (File file : fileList) {
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            assert (this.locations != null);
            this.locations.put(file.getName().replace(".yml", ""), (FileConfiguration)configuration);
        }
        return new Locate(this.plugin);
    }

    public String getString(String unlocalizedName, String id) {
        assert (this.locations != null);
        return this.locations.get(unlocalizedName).getString(id);
    }
}

