/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.utils.Inventory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.pulsedev.api.utils.Inventory.Inventory;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class InventoryManager {
    public static void createInventory(Inventory inventory) {
        File folder = new File(inventory.getPlugin().getDataFolder().getPath() + File.separator + "inventories");
        if (!folder.exists()) {
            folder.mkdir();
        }
        File file = new File(folder.getPath() + File.separator + inventory.getName() + ".json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((Object)inventory, (Appendable)writer);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static Inventory getInventory(Plugin plugin, String name) {
        Inventory inventory;
        FileReader reader = new FileReader(plugin.getDataFolder().getPath() + File.separator + "inventories" + File.separator + name + ".json");
        try {
            Gson gson = new Gson();
            inventory = (Inventory)gson.fromJson((Reader)reader, Inventory.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return null;
            }
        }
        reader.close();
        return inventory;
    }

    public static org.bukkit.inventory.Inventory getBukkitInventory(Inventory inventory) {
        org.bukkit.inventory.Inventory bukkitInventory = Bukkit.createInventory(null, (int)inventory.getSize(), (String)inventory.getName());
        for (Integer key : inventory.getItemStacks().keySet()) {
            bukkitInventory.setItem(key.intValue(), inventory.itemStackFromJson(inventory.getItemStacks().get(key)));
        }
        return bukkitInventory;
    }
}

