/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.utils.Inventory;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Inventory {
    private final int size;
    private final String name;
    private final transient Plugin plugin;
    private final HashMap<Integer, String> itemStacks = new HashMap();

    public Inventory(int size, String name, Plugin plugin) {
        this.size = size;
        this.name = name;
        this.plugin = plugin;
    }

    public void setItem(int slot, ItemStack itemStack) {
        this.itemStacks.put(slot, this.itemStackToJson(itemStack));
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public HashMap<Integer, String> getItemStacks() {
        return this.itemStacks;
    }

    public ItemStack itemStackFromJson(String id) {
        Gson gson = new Gson();
        return (ItemStack)gson.fromJson(id, ItemStack.class);
    }

    public String itemStackToJson(ItemStack itemStack) {
        Gson gson = new Gson();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", itemStack.getType().name());
        jsonObject.addProperty("amount", (Number)itemStack.getAmount());
        if (itemStack.getDurability() > 0) {
            jsonObject.addProperty("durability", (Number)itemStack.getDurability());
        }
        if (itemStack.hasItemMeta()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            JsonObject jsonMeta = new JsonObject();
            assert (itemMeta != null);
            if (itemMeta.hasCustomModelData()) {
                jsonMeta.addProperty("custom-model-data", (Number)itemMeta.getCustomModelData());
            }
            if (itemMeta.hasDisplayName()) {
                jsonMeta.addProperty("displayname", itemMeta.getDisplayName());
            }
            if (itemMeta.hasLocalizedName()) {
                jsonMeta.addProperty("localized-name", itemMeta.getLocalizedName());
            }
            if (itemMeta.isUnbreakable()) {
                jsonMeta.addProperty("unbreakable", Boolean.valueOf(true));
            }
            if (itemMeta.hasLore()) {
                JsonArray jsonLore = new JsonArray();
                Objects.requireNonNull(itemMeta.getLore()).forEach(string -> jsonLore.add((JsonElement)new JsonPrimitive(string)));
                jsonMeta.add("lore", (JsonElement)jsonLore);
            }
            if (itemMeta.hasEnchants()) {
                JsonArray jsonEnchant = new JsonArray();
                itemMeta.getEnchants().forEach((enchant, integer) -> jsonEnchant.add((JsonElement)new JsonPrimitive(enchant.getName() + ":" + integer)));
                jsonMeta.add("enchants", (JsonElement)jsonEnchant);
            }
            if (!itemMeta.getItemFlags().isEmpty()) {
                JsonArray jsonFlags = new JsonArray();
                itemMeta.getItemFlags().stream().map(Enum::name).forEach(str -> jsonFlags.add((JsonElement)new JsonPrimitive(str)));
                jsonMeta.add("flags", (JsonElement)jsonFlags);
            }
            jsonObject.add("item-meta", (JsonElement)jsonMeta);
        }
        return gson.toJson((JsonElement)jsonObject);
    }
}

