/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.Player;

import fr.pulsedev.api.DataManagement.SqlManager.SqlManager;
import fr.pulsedev.api.Interfaces.CustomPlugin;
import fr.pulsedev.api.utils.Inventory.Inventory;
import fr.pulsedev.api.utils.Inventory.InventoryManager;
import fr.pulsedev.api.utils.Lang.MessageConfiguration;
import java.util.Objects;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ApiPlayer
extends CraftPlayer {
    private final Player player;
    private final SqlManager sqlManager;
    private final CustomPlugin<?> plugin;

    public ApiPlayer(Player player, CustomPlugin<?> plugin) {
        super((CraftServer)player.getServer(), ((CraftPlayer)player).getHandle());
        this.plugin = plugin;
        this.player = player;
        this.sqlManager = new SqlManager(plugin.getSQL());
    }

    public boolean isAlreadyIntoDataBase() {
        return !this.sqlManager.getString("player", "uuid", this.player.getUniqueId().toString(), "name").equals("");
    }

    public void createDataBasePlayer() {
        this.sqlManager.insert("player", new Object[]{"name", "uuid", "location"}, new Object[]{this.player.getName(), this.player.getUniqueId(), this.plugin.getInstance().getConfig().getString("default-player-location")});
    }

    public String getLocationUnlocalizedName() {
        return this.sqlManager.getString("player", "uuid", this.player.getUniqueId().toString(), "location");
    }

    public void openInventory(Inventory inventory) {
        this.player.openInventory(InventoryManager.getBukkitInventory(Objects.requireNonNull(InventoryManager.getInventory(inventory.getPlugin(), inventory.getName()))));
    }

    public void sendMessage(MessageConfiguration messageConfiguration) {
        String messageToSend = this.plugin.getLocate().getString(this.getLocationUnlocalizedName(), messageConfiguration.getId());
        for (String key : messageConfiguration.getListOfReplacement().keySet()) {
            messageToSend = messageToSend.replace(key, messageConfiguration.getListOfReplacement().get(key));
        }
        this.player.sendMessage(messageToSend);
    }
}

