/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.Player;

import fr.pulsedev.api.DataManagement.RedisManager.RedisAccess;
import fr.pulsedev.api.DataManagement.SqlManager.SqlManager;
import fr.pulsedev.api.Interfaces.CustomPlugin;
import fr.pulsedev.api.Player.ApiPlayer;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;

public class AccountProvider {
    private final RedisAccess redisAccess = RedisAccess.INSTANCE;
    private final Player player;
    private String REDIS_KEY = "account:";
    private final CustomPlugin<?> customPlugin;

    public AccountProvider(Player player, CustomPlugin<?> customPlugin) {
        this.player = player;
        this.customPlugin = customPlugin;
    }

    public ApiPlayer getAccount() {
        ApiPlayer apiPlayer = this.getPlayerFromDataBase();
        if (this.getPlayerFromRedis() != null) {
            apiPlayer = this.getPlayerFromRedis();
        }
        return apiPlayer;
    }

    private ApiPlayer getPlayerFromRedis() {
        RedissonClient redissonClient = this.redisAccess.getRedissonClient();
        String key = this.REDIS_KEY + this.player.getName();
        RBucket accountRBucket = redissonClient.getBucket(key);
        return (ApiPlayer)((Object)accountRBucket.get());
    }

    private ApiPlayer getPlayerFromDataBase() {
        SqlManager sqlManager = new SqlManager(this.customPlugin.getSQL());
        return new ApiPlayer(Objects.requireNonNull(Bukkit.getPlayer((String)sqlManager.getString("player", "uuid", this.player.getUniqueId().toString(), "name"))), this.customPlugin);
    }
}

