/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.DataManagement.SqlManager;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class SQL {
    private Connection connection;
    private final String base;
    private final String host;
    private final String database;
    private final String user;
    private final String password;
    private final String port;

    public SQL(String base, String host, String port, String database, String user, String password) {
        this.base = base;
        this.host = host;
        this.port = port;
        this.database = database;
        this.user = user;
        this.password = password;
    }

    public void connect() {
        if (!this.isConnected()) {
            try {
                this.connection = DriverManager.getConnection(this.base + this.host + ":" + this.port + "/" + this.database, this.user, this.password);
                System.out.println("DataBase Connected");
            }
            catch (SQLException e) {
                System.out.println("Connection Error");
                e.printStackTrace();
            }
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.connection.close();
                System.out.println("DataBase Disconnected");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void request(String request) {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate(request);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

