/*
 * Decompiled with CFR 0.152.
 */
package fr.pulsedev.api.DataManagement.RedisManager;

import fr.pulsedev.api.DataManagement.RedisManager.RedisCredentials;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

public class RedisAccess {
    public static RedisAccess INSTANCE;
    private final RedissonClient redissonClient;
    private int threadNumber;
    private int nettyThreadsNumber;
    private int dateBaseNumber;

    public RedisAccess(RedisCredentials redisCredentials, int threadNumber, int nettyThreadsNumber, int dateBaseNumber) {
        INSTANCE = this;
        this.redissonClient = this.initRedisson(redisCredentials);
        this.threadNumber = threadNumber;
        this.nettyThreadsNumber = nettyThreadsNumber;
        this.dateBaseNumber = dateBaseNumber;
    }

    public RedisAccess(RedisCredentials redisCredentials, int threadNumber, int dateBaseNumber) {
        this(redisCredentials, threadNumber, threadNumber, dateBaseNumber);
    }

    public RedisAccess(RedisCredentials redisCredentials, int threadNumber) {
        this(redisCredentials, threadNumber, threadNumber, 0);
    }

    public RedisAccess(RedisCredentials redisCredentials) {
        this(redisCredentials, 0, 0, 0);
    }

    public static void init(RedisCredentials redisCredentials, int threadNumber, int nettyThreadsNumber, int dateBaseNumber) {
        new RedisAccess(redisCredentials, threadNumber, nettyThreadsNumber, dateBaseNumber);
    }

    public static void init(RedisCredentials redisCredentials, int threadNumber, int dateBaseNumber) {
        new RedisAccess(redisCredentials, threadNumber, dateBaseNumber);
    }

    public static void init(RedisCredentials redisCredentials, int threadNumber) {
        new RedisAccess(redisCredentials, threadNumber);
    }

    public static void init(RedisCredentials redisCredentials) {
        new RedisAccess(redisCredentials);
    }

    public void setThreadNumber(int threadNumber) {
        this.threadNumber = threadNumber;
    }

    public void setNettyThreadsNumber(int nettyThreadsNumber) {
        this.nettyThreadsNumber = nettyThreadsNumber;
    }

    public void setDateBaseNumber(int dateBaseNumber) {
        this.dateBaseNumber = dateBaseNumber;
    }

    public static void close() {
        INSTANCE.getRedissonClient().shutdown();
    }

    public RedissonClient initRedisson(RedisCredentials redisCredentials) {
        Config config = new Config();
        config.setCodec((Codec)new JsonJacksonCodec());
        config.setThreads(this.getThreadNumber());
        config.setNettyThreads(this.getNettyThreadsNumber());
        ((SingleServerConfig)config.useSingleServer().setAddress(redisCredentials.toRedisUrl()).setPassword(redisCredentials.getPassword())).setDatabase(this.getDateBaseNumber()).setClientName(redisCredentials.getClientName());
        return Redisson.create((Config)config);
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public int getThreadNumber() {
        return this.threadNumber;
    }

    public int getNettyThreadsNumber() {
        return this.nettyThreadsNumber;
    }

    public int getDateBaseNumber() {
        return this.dateBaseNumber;
    }
}

