/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Material;

public class BlockFlags {
    public static final long FULL_BOUNDS = BlockProperties.F_XZ100 | BlockProperties.F_HEIGHT100;
    public static final long SOLID_GROUND = BlockProperties.F_SOLID | BlockProperties.F_GROUND;
    public static final long FULLY_SOLID_BOUNDS = FULL_BOUNDS | SOLID_GROUND;

    public static void setFlagsAs(String id, Material mat) {
        BlockProperties.setBlockFlags(id, BlockProperties.getBlockFlags(mat));
    }

    public static void setFlagsAs(String id, String otherId) {
        BlockProperties.setBlockFlags(id, BlockProperties.getBlockFlags(otherId));
    }

    public static void setFlagsAs(Material newMat, Material mat) {
        BlockProperties.setBlockFlags(newMat, BlockProperties.getBlockFlags(mat));
    }

    public static void addFlags(String id, long flags) {
        BlockProperties.setBlockFlags(id, BlockProperties.getBlockFlags(id) | flags);
    }

    public static void addFlags(Material blockType, long flags) {
        BlockProperties.setBlockFlags(blockType, BlockProperties.getBlockFlags(blockType) | flags);
    }

    public static void removeFlags(String id, long flags) {
        BlockProperties.setBlockFlags(id, BlockProperties.getBlockFlags(id) & (flags ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static void removeFlags(Material mat, long flags) {
        BlockProperties.setBlockFlags(mat, BlockProperties.getBlockFlags(mat) & (flags ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static boolean hasAnyFlag(long flags, long testFlags) {
        return (flags & testFlags) != 0L;
    }

    public static boolean hasAllFlags(long flags, long testFlags) {
        return (flags & testFlags) == testFlags;
    }

    public static boolean hasNoFlags(long flags, long testFlags) {
        return (flags & testFlags) == 0L;
    }

    public static void setFullySolidFlags(String blockId) {
        BlockProperties.setBlockFlags(blockId, FULL_BOUNDS | SOLID_GROUND);
    }
}

