/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.entity;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.checks.moving.util.AuxMoving;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessVehicle;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PassengerUtil {
    public final IHandle<IEntityAccessVehicle> handleVehicle = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IEntityAccessVehicle.class);
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLoc2 = new Location(null, 0.0, 0.0, 0.0);

    public boolean isPassenger(Entity entity, Entity vehicle) {
        return this.handleVehicle.getHandle().getEntityPassengers(vehicle).contains(entity);
    }

    public Player getFirstPlayerPassenger(Entity entity) {
        List<Entity> passengers = this.handleVehicle.getHandle().getEntityPassengers(entity);
        while (!passengers.isEmpty() && (entity = passengers.get(0)) != null) {
            if (entity instanceof Player) {
                return (Player)entity;
            }
            passengers = this.handleVehicle.getHandle().getEntityPassengers(entity);
        }
        return null;
    }

    public Entity getLastNonPlayerVehicle(Entity passenger) {
        return this.getLastNonPlayerVehicle(passenger, false);
    }

    public Entity getLastNonPlayerVehicle(Entity passenger, boolean includePassenger) {
        Entity vehicle;
        Entity entity = vehicle = includePassenger ? passenger : passenger.getVehicle();
        while (vehicle != null) {
            if (vehicle instanceof Player) {
                return null;
            }
            if (!vehicle.isInsideVehicle()) break;
            vehicle = vehicle.getVehicle();
        }
        return vehicle;
    }

    public void teleportWithPassengers(Entity vehicle, Player player, Location location, boolean debug, IPlayerData pData) {
        List<Entity> originalPassengers = this.handleVehicle.getHandle().getEntityPassengers(vehicle);
        this.teleportWithPassengers(vehicle, player, location, debug, originalPassengers.toArray(new Entity[originalPassengers.size()]), false, pData);
    }

    public void teleportWithPassengers(Entity vehicle, Player player, Location location, boolean debug, Entity[] originalPassengers, boolean checkPassengers, IPlayerData pData) {
        MovingData data = pData.getGenericInstance(MovingData.class);
        data.isVehicleSetBack = true;
        int otherPlayers = 0;
        boolean playerIsOriginalPassenger = false;
        for (int i = 0; i < originalPassengers.length; ++i) {
            if (originalPassengers[i].equals(player)) {
                playerIsOriginalPassenger = true;
                break;
            }
            if (!(originalPassengers[i] instanceof Player)) continue;
            DataManager.getGenericInstance((Player)((Player)originalPassengers[i]), MovingData.class).isVehicleSetBack = true;
            ++otherPlayers;
        }
        boolean redoPassengers = true;
        if (!playerIsOriginalPassenger && debug) {
            CheckUtils.debug(player, CheckType.MOVING_VEHICLE, "Vehicle set back: This player is not an original passenger.");
        }
        boolean vehicleTeleported = false;
        boolean playerTeleported = false;
        int otherPlayersTeleported = 0;
        if (vehicle.isDead() || !vehicle.isValid()) {
            vehicleTeleported = false;
        } else if (redoPassengers) {
            vehicle.eject();
            vehicleTeleported = vehicle.teleport(LocUtil.clone(location), BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
        }
        if (redoPassengers) {
            if (!playerIsOriginalPassenger) {
                this.teleportPlayerPassenger(player, vehicle, location, vehicleTeleported, data, debug);
            }
            for (int i = 0; i < originalPassengers.length; ++i) {
                Entity passenger = originalPassengers[i];
                if (!passenger.isValid() || passenger.isDead()) continue;
                if (passenger instanceof Player) {
                    if (!this.teleportPlayerPassenger((Player)passenger, vehicle, location, vehicleTeleported, DataManager.getGenericInstance((Player)passenger, MovingData.class), debug)) continue;
                    if (player.equals(passenger)) {
                        playerTeleported = true;
                        continue;
                    }
                    ++otherPlayersTeleported;
                    continue;
                }
                if (passenger.teleport(location, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION) && vehicleTeleported && passenger.getLocation(this.useLoc2).distance(vehicle.getLocation(this.useLoc)) < 1.5 && this.handleVehicle.getHandle().addPassenger(passenger, vehicle)) continue;
            }
        }
        if (debug) {
            CheckUtils.debug(player, CheckType.MOVING_VEHICLE, "Vehicle set back resolution: " + location + " pt=" + playerTeleported + " vt=" + vehicleTeleported + (otherPlayers > 0 ? " opt=" + otherPlayersTeleported + "/" + otherPlayers : ""));
        }
        this.useLoc.setWorld(null);
        this.useLoc2.setWorld(null);
    }

    private final boolean teleportPlayerPassenger(Player player, Entity vehicle, Location location, boolean vehicleTeleported, MovingData data, boolean debug) {
        boolean playerTeleported;
        if (player.isOnline() && !player.isDead()) {
            data.prepareSetBack(location);
            playerTeleported = player.teleport(LocUtil.clone(location), BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
            data.resetTeleported();
            data.ws.resetConditions("reset.notinair");
            if (playerTeleported && vehicleTeleported && player.getLocation(this.useLoc2).distance(vehicle.getLocation(this.useLoc)) < 1.5) {
                if (!this.handleVehicle.getHandle().addPassenger((Entity)player, vehicle)) {
                    // empty if block
                }
                if (data.vehicleSetBacks.getFirstValidEntry(location) == null) {
                    if (debug) {
                        CheckUtils.debug(player, CheckType.MOVING_VEHICLE, "No set back is matching the vehicle location that it has just been set back to. Reset all lazily to: " + location);
                    }
                    data.vehicleSetBacks.resetAllLazily(location);
                }
                VehicleMoveData firstPastMove = data.vehicleMoves.getFirstPastMove();
                if (!firstPastMove.valid || firstPastMove.toIsValid || !TrigUtil.isSamePos((IGetPosition)firstPastMove.from, location)) {
                    MovingConfig cc = DataManager.getGenericInstance(player, MovingConfig.class);
                    NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class).resetVehiclePositions(vehicle, location, data, cc);
                }
            }
        } else {
            playerTeleported = false;
        }
        data.isVehicleSetBack = false;
        return playerTeleported;
    }
}

