/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.bktree;

import fr.neatmonster.nocheatplus.utilities.ds.bktree.BKModTree;

public class BKLevenshtein<N extends LevenNode<N>, L extends BKModTree.LookupEntry<char[], N>>
extends BKModTree<char[], N, L> {
    public BKLevenshtein(BKModTree.NodeFactory<char[], N> nodeFactory, BKModTree.LookupEntryFactory<char[], N, L> resultFactory) {
        super(nodeFactory, resultFactory);
    }

    @Override
    public int distance(char[] s, char[] t) {
        int i;
        int n = s.length;
        int m = t.length;
        if (n == m) {
            for (int i2 = 0; i2 < n && s[i2] == t[i2]; ++i2) {
                --m;
            }
            if (m == 0) {
                return 0;
            }
            m = n;
        }
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            char[] tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t[j - 1];
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s[i - 1] == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static class LevenNode<N extends LevenNode<N>>
    extends BKModTree.HashMapNode<char[], N> {
        public LevenNode(char[] value) {
            super(value);
        }
    }
}

