/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class InventoryUtil {
    public static List<Material> collectItemsBySuffix(String suffix) {
        suffix = suffix.toLowerCase();
        LinkedList<Material> res = new LinkedList<Material>();
        for (Material mat : Material.values()) {
            if (mat.isBlock() || !mat.name().toLowerCase().endsWith(suffix)) continue;
            res.add(mat);
        }
        return res;
    }

    public static List<Material> collectItemsByPrefix(String prefix) {
        prefix = prefix.toLowerCase();
        LinkedList<Material> res = new LinkedList<Material>();
        for (Material mat : Material.values()) {
            if (mat.isBlock() || !mat.name().toLowerCase().startsWith(prefix)) continue;
            res.add(mat);
        }
        return res;
    }

    public static int getFreeSlots(Inventory inventory) {
        ItemStack[] contents = inventory.getContents();
        int count = 0;
        for (int i = 0; i < contents.length; ++i) {
            if (!BlockProperties.isAir(contents[i])) continue;
            ++count;
        }
        return count;
    }

    public static int getStackCount(Inventory inventory, ItemStack reference) {
        if (inventory == null) {
            return 0;
        }
        if (reference == null) {
            return InventoryUtil.getFreeSlots(inventory);
        }
        Material mat = reference.getType();
        short durability = reference.getDurability();
        ItemStack[] contents = inventory.getContents();
        int count = 0;
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getType() != mat || stack.getDurability() != durability) continue;
            ++count;
        }
        return count;
    }

    public static int getStackCount(InventoryView view, ItemStack reference) {
        return InventoryUtil.getStackCount(view.getBottomInventory(), reference) + InventoryUtil.getStackCount(view.getTopInventory(), reference);
    }

    public static boolean closeOpenInventory(Player player) {
        if (InventoryUtil.hasInventoryOpen(player)) {
            player.closeInventory();
            return true;
        }
        return true;
    }

    public static boolean hasInventoryOpen(Player player) {
        InventoryView view = player.getOpenInventory();
        return view != null && view.getType() != InventoryType.CRAFTING;
    }

    public static ItemStack getFirstConsumableItemInHand(Player player) {
        ItemStack actualStack = Bridge1_9.getItemInMainHand(player);
        if (!(!Bridge1_9.hasGetItemInOffHand() || actualStack != null && InventoryUtil.isConsumable(actualStack.getType()) || (actualStack = Bridge1_9.getItemInOffHand(player)) != null && InventoryUtil.isConsumable(actualStack.getType()))) {
            actualStack = null;
        }
        return actualStack;
    }

    public static boolean isConsumable(ItemStack stack) {
        return stack == null ? false : InventoryUtil.isConsumable(stack.getType());
    }

    public static boolean isConsumable(Material type) {
        return type != null && (type.isEdible() || type == Material.POTION || type == Material.MILK_BUCKET);
    }

    public static boolean isItemBroken(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        Material mat = stack.getType();
        return stack.getDurability() >= mat.getMaxDurability();
    }
}

