/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.players;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.components.data.ICanHandleTimeRunningBackwards;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.data.IDataOnJoin;
import fr.neatmonster.nocheatplus.components.data.IDataOnLeave;
import fr.neatmonster.nocheatplus.components.data.IDataOnReload;
import fr.neatmonster.nocheatplus.components.data.IDataOnRemoveSubCheckData;
import fr.neatmonster.nocheatplus.components.data.IDataOnWorldChange;
import fr.neatmonster.nocheatplus.components.data.IDataOnWorldUnload;
import fr.neatmonster.nocheatplus.hooks.ExemptionContext;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.permissions.PermissionInfo;
import fr.neatmonster.nocheatplus.permissions.PermissionNode;
import fr.neatmonster.nocheatplus.permissions.PermissionPolicy;
import fr.neatmonster.nocheatplus.permissions.PermissionRegistry;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.PlayerCheckTypeTree;
import fr.neatmonster.nocheatplus.players.PlayerFactoryArgument;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.corw.DualSet;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import fr.neatmonster.nocheatplus.utilities.ds.map.InstanceMapLOW;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import fr.neatmonster.nocheatplus.worlds.WorldDataManager;
import fr.neatmonster.nocheatplus.worlds.WorldIdentifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlayerData
implements IPlayerData {
    private static ActionFrequency taskLoad = new ActionFrequency(6, 7L);
    private static final int ticksMonitored = taskLoad.numberOfBuckets() * (int)taskLoad.bucketDuration();
    private static final long msMonitored = ticksMonitored * 50;
    private static float heavyLoad = 500000.0f / (float)ticksMonitored;
    public static final String TAG_NOTIFY_OFF = "notify_off";
    public static final String TAG_OPTIMISTIC_CREATE = "optimistic_create";
    private static final short frequentTaskLazyDefaultDelay = 10;
    private static final short frequentTaskUnregisterDefaultDelay = 2;
    private final Lock lock = new ReentrantLock();
    private Set<String> tags = null;
    private final UUID playerId;
    private String playerName;
    private String playerNameLowerCase;
    private long lastJoinTime = 0L;
    private IWorldData currentWorldData = null;
    private final PermissionRegistry permissionRegistry;
    private final HashMapLOW<Integer, PermissionNode> permissions = new HashMapLOW(this.lock, 35);
    private final InstanceMapLOW dataCache = new InstanceMapLOW(this.lock, 24);
    private boolean requestUpdateInventory = false;
    private boolean requestPlayerSetBack = false;
    private boolean frequentPlayerTaskShouldBeScheduled = false;
    private final DualSet<RegisteredPermission> updatePermissions = new DualSet(this.lock);
    private final DualSet<RegisteredPermission> updatePermissionsLazy = new DualSet(this.lock);
    private final PlayerCheckTypeTree checkTypeTree = new PlayerCheckTypeTree(this.lock);
    private short frequentTaskDelayUnregister = 0;
    private short frequentTaskDelayLazy = 0;

    public PlayerData(UUID playerId, String playerName, PermissionRegistry permissionRegistry) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.playerNameLowerCase = playerName.toLowerCase();
        this.permissionRegistry = permissionRegistry;
    }

    void updatePlayerName(String exactPlayerName) {
        this.playerName = exactPlayerName;
        this.playerNameLowerCase = exactPlayerName.toLowerCase();
    }

    boolean processTickFrequent(int tick, long timeLast) {
        if (this.frequentTaskDelayUnregister == 0) {
            this.frequentTaskDelayUnregister = (short)2;
        }
        if (this.frequentTaskDelayLazy == 0) {
            this.frequentTaskDelayLazy = (short)10;
        }
        boolean busy = false;
        Player player = DataManager.getPlayer(this.playerId);
        if (this.hasFrequentTasks()) {
            this.frequentTasks(tick, timeLast, player);
            busy = true;
        }
        if ((this.frequentTaskDelayLazy = (short)(this.frequentTaskDelayLazy - 1)) == 0 && !this.lazyTasks(tick, timeLast, player)) {
            busy = true;
        }
        if (busy || this.frequentTaskDelayLazy > 0) {
            this.frequentTaskDelayUnregister = (short)2;
            return false;
        }
        this.frequentTaskDelayUnregister = (short)(this.frequentTaskDelayUnregister - 1);
        if (this.frequentTaskDelayUnregister == 0) {
            if (this.hasLazyTasks() || this.hasFrequentTasks()) {
                this.frequentTaskDelayLazy = (short)10;
                return false;
            }
            this.frequentPlayerTaskShouldBeScheduled = false;
            return true;
        }
        return false;
    }

    private boolean hasFrequentTasks() {
        return !this.updatePermissions.isEmtpyAfterMergePrimaryThread() || this.requestPlayerSetBack || this.requestUpdateInventory;
    }

    private void frequentTasks(int tick, long timeLast, Player player) {
        if (player != null && player.isOnline()) {
            Collection updatable;
            long nanos = System.nanoTime();
            if (this.requestPlayerSetBack) {
                this.requestPlayerSetBack = false;
                MovingUtil.processStoredSetBack(player, "Player set back on tick: ", this);
            }
            if (this.requestUpdateInventory) {
                this.requestUpdateInventory = false;
                player.updateInventory();
            }
            if ((updatable = this.updatePermissions.getMergePrimaryThreadAndClear()) != null) {
                for (RegisteredPermission registeredPermission : updatable) {
                    this.hasPermission(registeredPermission, player);
                }
            }
            if ((nanos = System.nanoTime() - nanos) > 0L) {
                taskLoad.add(tick, nanos);
            }
        }
    }

    private boolean hasLazyTasks() {
        return !this.updatePermissionsLazy.isEmtpyAfterMergePrimaryThread();
    }

    private boolean lazyTasks(int tick, long timeLast, Player player) {
        if (player == null) {
            return true;
        }
        long nanos = System.nanoTime();
        taskLoad.update(tick);
        boolean isHeavyLoad = taskLoad.score(1.0f) > heavyLoad || TickTask.getLag(msMonitored, true) > 1.1f;
        this.updatePermissionsLazy.mergePrimaryThread();
        Iterator it = this.updatePermissionsLazy.iteratorPrimaryThread();
        while (it.hasNext()) {
            this.hasPermission((RegisteredPermission)it.next(), player);
            it.remove();
            if (!isHeavyLoad) continue;
        }
        boolean hasWrk = it.hasNext();
        nanos = System.nanoTime() - nanos;
        if (nanos > 0L) {
            taskLoad.add(tick, nanos);
        }
        return !hasWrk;
    }

    private void registerFrequentPlayerTask() {
        if (Bukkit.isPrimaryThread()) {
            this.registerFrequentPlayerTaskPrimaryThread();
        } else {
            this.registerFrequentPlayerTaskAsynchronous();
        }
    }

    private void registerFrequentPlayerTaskPrimaryThread() {
        this.frequentPlayerTaskShouldBeScheduled = true;
        DataManager.registerFrequentPlayerTaskPrimaryThread(this.playerId);
    }

    private void registerFrequentPlayerTaskAsynchronous() {
        this.frequentPlayerTaskShouldBeScheduled = true;
        DataManager.registerFrequentPlayerTaskAsynchronous(this.playerId);
    }

    private boolean isFrequentPlayerTaskScheduled() {
        return DataManager.isFrequentPlayerTaskScheduled(this.playerId);
    }

    private PermissionNode getOrCreatePermissionNode(RegisteredPermission registeredPermission) {
        PermissionNode node = new PermissionNode(this.permissionRegistry.getPermissionInfo(registeredPermission.getId()));
        PermissionNode oldNode = this.permissions.putIfAbsent(registeredPermission.getId(), node);
        return oldNode == null ? node : oldNode;
    }

    private AlmostBoolean fetchPermission(RegisteredPermission registeredPermission, Player player) {
        if (Bukkit.isPrimaryThread()) {
            if (player == null && (player = DataManager.getPlayer(this.playerId)) == null) {
                return AlmostBoolean.MAYBE;
            }
            return player.hasPermission(registeredPermission.getBukkitPermission()) ? AlmostBoolean.YES : AlmostBoolean.NO;
        }
        this.requestPermissionUpdate(registeredPermission);
        return AlmostBoolean.MAYBE;
    }

    public void handleTimeRanBackwards(Collection<Class<? extends IData>> dataTypes) {
        Iterator<Map.Entry<Integer, PermissionNode>> it = this.permissions.iterator();
        long timeNow = System.currentTimeMillis();
        block3: while (it.hasNext()) {
            PermissionNode node = it.next().getValue();
            switch (node.getFetchingPolicy()) {
                case INTERVAL: {
                    node.invalidate();
                    continue block3;
                }
            }
            if (node.getLastFetch() <= timeNow) continue;
            node.setState(node.getLastState(), timeNow);
        }
        for (Class<? extends IData> type : dataTypes) {
            IData obj = this.dataCache.get(type);
            if (obj == null || !(obj instanceof ICanHandleTimeRunningBackwards)) continue;
            ((ICanHandleTimeRunningBackwards)((Object)obj)).handleTimeRanBackwards();
        }
    }

    void requestPermissionUpdatePrimaryThread(RegisteredPermission registeredPermission) {
        this.updatePermissions.addPrimaryThread(registeredPermission);
        this.registerFrequentPlayerTaskPrimaryThread();
    }

    void requestPermissionUpdateAsynchronous(RegisteredPermission registeredPermission) {
        this.updatePermissions.addAsynchronous(registeredPermission);
        this.registerFrequentPlayerTaskAsynchronous();
    }

    private void requestLazyPermissionsUpdateNonEmpty(RegisteredPermission ... registeredPermissions) {
        if (Bukkit.isPrimaryThread()) {
            this.requestLazyPermissionUpdatePrimaryThread(registeredPermissions);
        } else {
            this.requestLazyPermissionUpdateAsynchronous(registeredPermissions);
        }
    }

    void requestLazyPermissionUpdatePrimaryThread(RegisteredPermission ... registeredPermissions) {
        this.updatePermissionsLazy.addAllPrimaryThread(Arrays.asList(registeredPermissions));
        this.registerFrequentPlayerTaskPrimaryThread();
    }

    void requestLazyPermissionUpdateAsynchronous(RegisteredPermission ... registeredPermissions) {
        this.updatePermissionsLazy.addAllAsynchronous(Arrays.asList(registeredPermissions));
        this.registerFrequentPlayerTaskAsynchronous();
    }

    void onPlayerLeave(Player player, long timeNow, Collection<Class<? extends IDataOnLeave>> types) {
        for (Class<? extends IDataOnLeave> type : types) {
            IDataOnLeave instance = this.dataCache.get(type);
            if (instance == null || !instance.dataOnLeave(player, this)) continue;
            this.dataCache.remove(type);
        }
        this.invalidateOffline();
    }

    void onPlayerJoin(Player player, World world, long timeNow, WorldDataManager worldDataManager, Collection<Class<? extends IDataOnJoin>> types) {
        this.updateCurrentWorld(world, worldDataManager);
        this.invalidateOffline();
        for (Class<? extends IDataOnJoin> type : types) {
            IDataOnJoin instance = this.dataCache.get(type);
            if (instance == null || !instance.dataOnJoin(player, this)) continue;
            this.dataCache.remove(type);
        }
        this.requestLazyPermissionUpdate(this.permissionRegistry.getPreferKeepUpdatedOffline());
        this.lastJoinTime = timeNow;
    }

    private void updateCurrentWorld(World world, WorldDataManager worldDataManager) {
        this.updateCurrentWorld(worldDataManager.getWorldData(world));
    }

    void updateCurrentWorld(IWorldData worldData) {
        if (this.currentWorldData != worldData) {
            this.currentWorldData = worldData;
            ((PlayerCheckTypeTree.PlayerCheckTypeTreeNode)this.checkTypeTree.getNode(CheckType.ALL)).updateDebug(worldData);
        }
    }

    private void invalidateOffline() {
        Iterator<Map.Entry<Integer, PermissionNode>> it = this.permissions.iterator();
        while (it.hasNext()) {
            PermissionNode node = it.next().getValue();
            PermissionInfo info = node.getPermissionInfo();
            if (!info.invalidationOffline() && !info.invalidationWorld()) continue;
            node.invalidate();
        }
    }

    void onPlayerChangedWorld(Player player, World oldWorld, World newWorld, WorldDataManager worldDataManager, Collection<Class<? extends IDataOnWorldChange>> types) {
        this.updateCurrentWorld(newWorld, worldDataManager);
        Iterator<Map.Entry<Integer, PermissionNode>> it = this.permissions.iterator();
        while (it.hasNext()) {
            PermissionNode node = it.next().getValue();
            PermissionInfo info = node.getPermissionInfo();
            if (!info.invalidationWorld()) continue;
            node.invalidate();
        }
        this.requestLazyPermissionUpdate(this.permissionRegistry.getPreferKeepUpdatedWorld());
        for (Class<? extends IDataOnWorldChange> type : types) {
            IDataOnWorldChange instance = this.dataCache.get(type);
            if (instance == null || !instance.dataOnWorldChange(player, this, oldWorld, newWorld)) continue;
            this.dataCache.remove(type);
        }
    }

    @Override
    public boolean hasPermission(RegisteredPermission registeredPermission, Player player) {
        AlmostBoolean fRes;
        PermissionNode node = this.permissions.get(registeredPermission.getId());
        if (node == null) {
            node = this.getOrCreatePermissionNode(registeredPermission);
        }
        PermissionPolicy.FetchingPolicy fetchingPolicy = node.getFetchingPolicy();
        switch (fetchingPolicy) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        AlmostBoolean lastState = node.getLastState();
        if (lastState != AlmostBoolean.MAYBE) {
            switch (fetchingPolicy) {
                case ONCE: {
                    return lastState.decide();
                }
                case INTERVAL: {
                    if (System.currentTimeMillis() - node.getLastFetch() >= node.getFetchInterval()) break;
                    return lastState.decide();
                }
            }
        }
        if ((fRes = this.fetchPermission(registeredPermission, player)) == AlmostBoolean.MAYBE) {
            return lastState.decide();
        }
        node.setState(fRes, System.currentTimeMillis());
        return fRes.decide();
    }

    @Override
    public void requestPermissionUpdate(RegisteredPermission registeredPermission) {
        if (Bukkit.isPrimaryThread()) {
            this.requestPermissionUpdatePrimaryThread(registeredPermission);
        } else {
            this.requestPermissionUpdateAsynchronous(registeredPermission);
        }
    }

    @Override
    public void requestLazyPermissionUpdate(RegisteredPermission ... registeredPermissions) {
        if (registeredPermissions == null || registeredPermissions.length == 0) {
            return;
        }
        this.requestLazyPermissionsUpdateNonEmpty(registeredPermissions);
    }

    public void removeData(boolean keepEssentialData) {
        this.permissions.clear();
        this.updatePermissions.clearPrimaryThread();
        this.updatePermissionsLazy.clearPrimaryThread();
        this.dataCache.clear();
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public String getPlayerNameLowerCase() {
        return this.playerNameLowerCase;
    }

    @Override
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public long getLastJoinTime() {
        return this.lastJoinTime;
    }

    @Override
    public void exempt(CheckType checkType) {
        this.checkTypeTree.exempt(checkType, ExemptionContext.LEGACY_NON_NESTED);
    }

    @Override
    public void unexempt(CheckType checkType) {
        this.checkTypeTree.unexemptAll(checkType, ExemptionContext.LEGACY_NON_NESTED);
    }

    @Override
    public void exempt(CheckType checkType, ExemptionContext context) {
        this.checkTypeTree.exempt(checkType, context);
    }

    @Override
    public void unexempt(CheckType checkType, ExemptionContext context) {
        this.checkTypeTree.unexempt(checkType, context);
    }

    @Override
    public void unexemptAll(CheckType checkType, ExemptionContext context) {
        this.checkTypeTree.unexemptAll(checkType, context);
    }

    @Override
    public boolean isExempted(CheckType checkType) {
        return this.checkTypeTree.isExempted(checkType);
    }

    @Override
    public void clearAllExemptions() {
        this.checkTypeTree.clearAllExemptions();
    }

    @Override
    public void clearAllExemptions(CheckType checkType) {
        this.checkTypeTree.clearAllExemptions(checkType);
    }

    @Override
    public WorldIdentifier getCurrentWorldIdentifier() {
        return this.currentWorldData.getWorldIdentifier();
    }

    @Override
    public IWorldData getCurrentWorldData() {
        return this.currentWorldData;
    }

    @Override
    public IWorldData getCurrentWorldDataSafe() {
        return this.currentWorldData == null ? NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().getDefaultWorldData() : this.currentWorldData;
    }

    @Override
    public boolean isCheckActive(CheckType checkType, Player player) {
        return this.isCheckActive(checkType, player, this.getCurrentWorldDataSafe());
    }

    @Override
    public boolean isCheckActive(CheckType checkType, Player player, IWorldData worldData) {
        return worldData.isCheckActive(checkType) && !this.hasBypass(checkType, player, worldData);
    }

    @Override
    public boolean hasBypass(CheckType checkType, Player player) {
        return this.hasBypass(checkType, player, this.getCurrentWorldDataSafe());
    }

    public boolean hasBypass(CheckType checkType, Player player, IWorldData worldData) {
        if (NCPExemptionManager.isExempted(player, checkType)) {
            return true;
        }
        RegisteredPermission permission = checkType.getPermission();
        return permission != null && this.hasPermission(permission, player);
    }

    @Override
    public boolean isDebugActive(CheckType checkType) {
        return ((PlayerCheckTypeTree.PlayerCheckTypeTreeNode)this.checkTypeTree.getNode(checkType)).isDebugActive();
    }

    @Override
    public void resetDebug() {
        this.resetDebug(CheckType.ALL);
    }

    @Override
    public void resetDebug(CheckType checkType) {
        ((PlayerCheckTypeTree.PlayerCheckTypeTreeNode)this.checkTypeTree.getNode(checkType)).resetDebug(this.currentWorldData == null ? this.getCurrentWorldDataSafe() : this.currentWorldData);
    }

    @Override
    public void overrideDebug(CheckType checkType, AlmostBoolean active, OverrideType overrideType, boolean overrideChildren) {
        ((PlayerCheckTypeTree.PlayerCheckTypeTreeNode)this.checkTypeTree.getNode(CheckType.ALL)).overrideDebug(checkType, active, overrideType, overrideChildren);
    }

    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
            if (this.tags.isEmpty()) {
                this.tags = null;
            }
        }
    }

    public void setTag(String tag, boolean add) {
        if (add) {
            this.addTag(tag);
        } else {
            this.removeTag(tag);
        }
    }

    @Override
    public boolean getNotifyOff() {
        return this.hasTag(TAG_NOTIFY_OFF);
    }

    @Override
    public void setNotifyOff(boolean notifyOff) {
        this.setTag(TAG_NOTIFY_OFF, notifyOff);
    }

    @Override
    public void requestUpdateInventory() {
        this.requestUpdateInventory = true;
        this.registerFrequentPlayerTask();
    }

    @Override
    public void requestPlayerSetBack() {
        this.requestPlayerSetBack = true;
        this.registerFrequentPlayerTask();
    }

    @Override
    public boolean isPlayerSetBackScheduled() {
        return this.requestPlayerSetBack && (this.frequentPlayerTaskShouldBeScheduled || this.isFrequentPlayerTaskScheduled());
    }

    @Override
    public <T> T getGenericInstance(Class<T> registeredFor) {
        T res = this.dataCache.get(registeredFor);
        if (res == null) {
            return this.cacheMissGenericInstance(registeredFor);
        }
        return res;
    }

    private <T> T cacheMissGenericInstance(Class<T> registeredFor) {
        T res = DataManager.getFromFactory(registeredFor, new PlayerFactoryArgument(this, this.getCurrentWorldDataSafe()));
        if (res != null) {
            return this.putDataCache(registeredFor, res);
        }
        res = this.getCurrentWorldDataSafe().getGenericInstance(registeredFor);
        return res == null ? null : (T)this.putDataCache(registeredFor, res);
    }

    private <T> T putDataCache(Class<T> registeredFor, T instance) {
        T previousInstance = this.dataCache.putIfAbsent(registeredFor, instance);
        return previousInstance == null ? instance : previousInstance;
    }

    @Override
    public <T> void removeGenericInstance(Class<T> type) {
        this.dataCache.remove(type);
    }

    @Override
    public void removeAllGenericInstances(Collection<Class<?>> types) {
        if (this.dataCache.isEmpty()) {
            return;
        }
        this.dataCache.remove(types);
    }

    @Override
    public void removeSubCheckData(Collection<Class<? extends IDataOnRemoveSubCheckData>> types, Collection<CheckType> checkTypes) {
        LinkedList removeTypes = new LinkedList();
        for (Class<? extends IDataOnRemoveSubCheckData> type : types) {
            IDataOnRemoveSubCheckData impl = this.dataCache.get(type);
            if (impl == null || !impl.dataOnRemoveSubCheckData(checkTypes)) continue;
            removeTypes.add(type);
        }
        if (!removeTypes.isEmpty()) {
            this.dataCache.remove(removeTypes);
        }
    }

    public void adjustSettings(Set<RegisteredPermission> changedPermissions) {
        Iterator<RegisteredPermission> it = changedPermissions.iterator();
        while (it.hasNext()) {
            PermissionNode node = this.permissions.get(it.next().getId());
            if (node == null) continue;
            node.invalidate();
        }
    }

    public void onWorldUnload(World world, Collection<Class<? extends IDataOnWorldUnload>> types) {
        for (Class<? extends IDataOnWorldUnload> type : types) {
            IDataOnWorldUnload instance = this.dataCache.get(type);
            if (instance == null || !instance.dataOnWorldUnload(world, this)) continue;
            this.dataCache.remove(type);
        }
    }

    public void onReload(Collection<Class<? extends IDataOnReload>> types) {
        for (Class<? extends IDataOnReload> type : types) {
            IDataOnReload instance = this.dataCache.get(type);
            if (instance == null || !instance.dataOnReload(this)) continue;
            this.dataCache.remove(type);
        }
    }
}

