/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging.debug;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Location;
import org.bukkit.Material;

public class DebugUtil {
    public static String formatMove(Location from, Location to) {
        StringBuilder builder = new StringBuilder(128);
        DebugUtil.addMove(from, to, null, builder);
        return builder.toString();
    }

    public static void addLocation(Location loc, StringBuilder builder) {
        builder.append(LocUtil.simpleFormat(loc));
    }

    public static void addLocation(PlayerLocation loc, StringBuilder builder) {
        builder.append(LocUtil.simpleFormat(loc));
    }

    public static void addMove(PlayerLocation from, PlayerLocation to, Location loc, StringBuilder builder) {
        if (loc != null && !from.isSamePos(loc)) {
            builder.append("Location: ");
            DebugUtil.addLocation(loc, builder);
            builder.append("\n");
        }
        DebugUtil.addMove(from, to, builder);
    }

    public static void addMove(Location from, Location to, Location loc, StringBuilder builder) {
        if (loc != null && !TrigUtil.isSamePos(from, loc)) {
            builder.append("Location: ");
            DebugUtil.addLocation(loc, builder);
            builder.append("\n");
        }
        DebugUtil.addMove(from, to, builder);
    }

    public static void addMove(PlayerLocation from, PlayerLocation to, StringBuilder builder) {
        builder.append("From: ");
        DebugUtil.addLocation(from, builder);
        builder.append("\n");
        builder.append("To: ");
        DebugUtil.addLocation(to, builder);
    }

    public static void addMove(Location from, Location to, StringBuilder builder) {
        builder.append("From: ");
        DebugUtil.addLocation(from, builder);
        builder.append("\n");
        builder.append("To: ");
        DebugUtil.addLocation(to, builder);
    }

    public static void addBlockBelowInfo(StringBuilder builder, PlayerLocation loc, String tag) {
        DebugUtil.addBlockInfo(builder, loc.getBlockCache(), loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ(), tag + " below");
    }

    public static void addBlockInfo(StringBuilder builder, PlayerLocation loc, String tag) {
        DebugUtil.addBlockInfo(builder, loc.getBlockCache(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), tag);
    }

    public static void addBlockInfo(StringBuilder builder, BlockCache blockCache, int x, int y, int z, String messagePrefix) {
        if (messagePrefix != null && !messagePrefix.isEmpty()) {
            builder.append(messagePrefix);
        }
        builder.append(" id=");
        BlockCache.IBlockCacheNode node = blockCache.getOrCreateBlockCacheNode(x, y, z, true);
        Material id = node.getType();
        builder.append(id);
        builder.append(" data=");
        builder.append(node.getData());
        double[] bounds = node.getBounds();
        if (bounds != null) {
            double minHeight = BlockProperties.getGroundMinHeight(blockCache, x, y, z, node, BlockProperties.getBlockFlags(id));
            builder.append(" shape=[");
            builder.append(bounds[0]);
            builder.append(", ");
            builder.append(bounds[1]);
            builder.append(", ");
            builder.append(bounds[2]);
            builder.append(", ");
            builder.append(bounds[3]);
            builder.append(", ");
            builder.append(minHeight == bounds[4] ? Double.valueOf(minHeight) : minHeight + ".." + bounds[4]);
            builder.append(", ");
            builder.append(bounds[5]);
            builder.append("]");
        }
    }

    public static boolean debug(String message, boolean returnValue) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, message);
        return returnValue;
    }

    public static void debug(String message) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, message);
    }

    public static String toJava(double[] doubles) {
        StringBuilder builder = new StringBuilder(20 + doubles.length * 20);
        DebugUtil.toJava(doubles, builder);
        return builder.toString();
    }

    public static void toJava(double[] doubles, StringBuilder builder) {
        if (doubles == null) {
            builder.append("null");
            return;
        }
        builder.append("new double[] {");
        if (doubles.length > 0) {
            builder.append(doubles[0]);
        }
        for (int i = 1; i < doubles.length; ++i) {
            builder.append(", " + doubles[i]);
        }
        builder.append("}");
    }
}

