/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.event.mini;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.components.registry.feature.ComponentWithName;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.event.mini.MiniListenerRegistry;
import fr.neatmonster.nocheatplus.event.mini.MiniListenerWithOrder;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public abstract class MultiListenerRegistry<EB, P>
extends MiniListenerRegistry<EB, P> {
    protected <E extends EB> MiniListener<E> register(Object listener, Method method, P basePriority, RegistrationOrder defaultOrder, boolean ignoreCancelled) {
        RegistrationOrder order = null;
        if (method.getClass().isAnnotationPresent(RegistrationOrder.RegisterMethodWithOrder.class)) {
            order = new RegistrationOrder(method.getClass().getAnnotation(RegistrationOrder.RegisterMethodWithOrder.class));
        }
        if (order == null) {
            order = defaultOrder;
        }
        MiniListener<E> miniListener = this.getMiniListener(listener, method, order, basePriority);
        if (listener == null) {
            return null;
        }
        this.register(method.getParameterTypes()[0], miniListener, basePriority, defaultOrder, ignoreCancelled);
        return miniListener;
    }

    protected <E extends EB> MiniListener<E> getMiniListener(Object listener, Method method, RegistrationOrder order, P basePriority) {
        return new AutoListener(method.getParameterTypes()[0], listener, method, order, basePriority);
    }

    protected boolean check_and_prepare_method(Method method) {
        try {
            if (!method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1) {
                return false;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected Collection<MiniListener<? extends EB>> register(Object listener, P defaultPriority, RegistrationOrder defaultOrder, boolean defaultIgnoreCancelled) {
        ArrayList<MiniListener<EB>> listeners = new ArrayList<MiniListener<EB>>();
        Class<?> listenerClass = listener.getClass();
        RegistrationOrder order = null;
        if (listenerClass.isAnnotationPresent(RegistrationOrder.RegisterEventsWithOrder.class)) {
            order = new RegistrationOrder(listenerClass.getAnnotation(RegistrationOrder.RegisterEventsWithOrder.class));
        }
        if (order == null) {
            order = defaultOrder;
        }
        for (Method method : listenerClass.getMethods()) {
            if (!this.shouldBeEventHandler(method)) continue;
            MiniListener miniListener = null;
            if (this.check_and_prepare_method(method)) {
                miniListener = this.register(listener, method, this.getPriority(method, defaultPriority), order, this.getIgnoreCancelled(method, defaultIgnoreCancelled));
            }
            if (miniListener == null) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().severe(Streams.STATUS, "Could not register event listener: " + listener.getClass().getName() + "#" + method.getName());
                continue;
            }
            listeners.add(miniListener);
        }
        if (!listeners.isEmpty()) {
            this.attach(listeners, listener);
        }
        return listeners;
    }

    protected abstract boolean shouldBeEventHandler(Method var1);

    protected abstract boolean getIgnoreCancelled(Method var1, boolean var2);

    protected abstract P getPriority(Method var1, P var2);

    protected class AutoListener<E>
    implements MiniListenerWithOrder<E>,
    ComponentWithName {
        private final Class<E> eventClass;
        private final Object listener;
        private final Method method;
        private final RegistrationOrder order;
        private final P basePriority;

        private AutoListener(Class<E> eventClass, Object listener, Method method, RegistrationOrder order, P basePriority) {
            this.eventClass = eventClass;
            this.listener = listener;
            this.method = method;
            this.order = order;
            this.basePriority = basePriority;
        }

        @Override
        public void onEvent(E event) {
            try {
                this.method.invoke(this.listener, event);
            }
            catch (InvocationTargetException e) {
                this.onException(event, e);
            }
            catch (IllegalArgumentException e) {
                this.onException(event, e);
            }
            catch (IllegalAccessException e) {
                this.onException(event, e);
            }
        }

        private void onException(E event, Throwable t) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("Exception:\n");
            builder.append(StringUtil.throwableToString(t));
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                builder.append("caused by:\n");
                builder.append(StringUtil.throwableToString(t.getCause()));
            }
            StaticLog.logOnce(Level.SEVERE, "Exception with " + this.getComponentName() + ", processing " + event.getClass().getName() + ": " + t.getClass().getSimpleName(), builder.toString());
        }

        @Override
        public RegistrationOrder getRegistrationOrder() {
            return this.order;
        }

        @Override
        public String getComponentName() {
            return "AutoListener(" + this.listener.getClass().getName() + "." + this.method.getName() + "/" + this.eventClass.getName() + "/" + this.basePriority + ")";
        }
    }
}

