/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.config;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.yaml.snakeyaml.DumperOptions;

public class RawConfigFile
extends YamlConfiguration {
    protected final Map<String, Integer> lastChangedBuildNumbers = new HashMap<String, Integer>();

    private static String prepareMatchMaterial(String content) {
        return content.replace(' ', '_').replace('-', '_').replace('.', '_');
    }

    public static Material parseMaterial(String content) {
        content = content.trim().toUpperCase();
        try {
            return Material.matchMaterial((String)RawConfigFile.prepareMatchMaterial(content));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setVersionDependent(String path, String cmpVersion, Object valueLT, Object valueEQ, Object valueGT, Object valueUnknown) {
        this.set(path, ServerVersion.select(cmpVersion, valueLT, valueEQ, valueGT, valueUnknown));
    }

    public double getDouble(String path, double min, double max, double preset) {
        double value = this.getDouble(path, preset);
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public long getLong(String path, long min, long max, long preset) {
        long value = this.getLong(path, preset);
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public long getInt(String path, int min, int max, int preset) {
        int value = this.getInt(path, preset);
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public AlmostBoolean getAlmostBoolean(String path, AlmostBoolean defaultValue) {
        AlmostBoolean choice = AlmostBoolean.match(this.getString(path, null));
        return choice == null ? defaultValue : choice;
    }

    public boolean getAlmostBoolean(String path, boolean decideOptimistically, boolean trueForNotSet) {
        AlmostBoolean ref = this.getAlmostBoolean(path, null);
        if (ref == null) {
            return trueForNotSet;
        }
        if (decideOptimistically) {
            return ref.decideOptimistically();
        }
        return ref.decide();
    }

    public void readMaterialFromList(String path, Collection<Material> target) {
        List content = this.getStringList(path);
        if (content == null || content.isEmpty()) {
            return;
        }
        for (String entry : content) {
            Material mat = RawConfigFile.parseMaterial(entry);
            if (mat == null) {
                StaticLog.logWarning("Bad material entry (" + path + "): " + entry);
                continue;
            }
            target.add(mat);
        }
    }

    public void readDoubleValuesForEntityTypes(String sectionPath, Map<EntityType, Double> map, double defaultValue, boolean allowDefault) {
        String path;
        String ucKey;
        ConfigurationSection section = this.getConfigurationSection(sectionPath);
        if (section == null) {
            if (allowDefault && !map.containsKey(null)) {
                map.put(null, defaultValue);
            }
            return;
        }
        if (allowDefault) {
            for (String key : section.getKeys(false)) {
                ucKey = key.trim().toUpperCase();
                path = sectionPath + "." + key;
                if (!ucKey.equals("DEFAULT")) continue;
                defaultValue = this.getDouble(path, defaultValue);
                map.put(null, defaultValue);
            }
            if (!map.containsKey(null)) {
                map.put(null, defaultValue);
            }
        }
        for (String key : section.getKeys(false)) {
            ucKey = key.trim().toUpperCase();
            path = sectionPath + "." + key;
            if (allowDefault && ucKey.equals("DEFAULT")) continue;
            EntityType type = null;
            try {
                type = EntityType.valueOf((String)ucKey);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (type == null) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "Bad entity type at '" + path + "': " + key);
                continue;
            }
            map.put(type, this.getDouble(path, defaultValue));
        }
    }

    public String saveToString() {
        try {
            Field op = YamlConfiguration.class.getDeclaredField("yamlOptions");
            op.setAccessible(true);
            DumperOptions options = (DumperOptions)op.get((Object)this);
            options.setWidth(200);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.saveToString();
    }

    public void set(String path, Object value, int lastChangedBuildNumber) {
        this.set(path, value);
        this.setLastChangedBuildNumber(path, lastChangedBuildNumber);
    }

    public void setLastChangedBuildNumber(String path, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Build number must be greater than zero. Got " + value + " for path: " + path);
        }
        this.lastChangedBuildNumbers.put(path, value);
    }

    public Map<String, Integer> getLastChangedBuildNumbers() {
        return Collections.unmodifiableMap(this.lastChangedBuildNumbers);
    }

    public int getMaxLastChangedBuildNumber() {
        int max = 0;
        for (Integer v : this.lastChangedBuildNumbers.values()) {
            if (v == null) continue;
            max = Math.max(max, v);
        }
        return max;
    }
}

