/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.meta;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.components.registry.meta.IRichTypeSetRegistry;
import fr.neatmonster.nocheatplus.components.registry.meta.TypeSetRegistry;
import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class RichTypeSetRegistry
implements IRichTypeSetRegistry {
    private final Lock lock;
    private final TypeSetRegistry groupedTypes;
    private final HashMapLOW<CheckType, TypeSetRegistry> groupedTypesByCheckType;

    public RichTypeSetRegistry(Lock lock) {
        this.lock = lock;
        this.groupedTypes = new TypeSetRegistry(lock);
        this.groupedTypesByCheckType = new HashMapLOW(lock, 35);
    }

    @Override
    public <T> Collection<Class<? extends T>> getGroupedTypes(Class<T> groupType) {
        return this.groupedTypes.getGroupedTypes(groupType);
    }

    @Override
    public <T> Collection<Class<? extends T>> getGroupedTypes(Class<T> groupType, CheckType checkType) {
        TypeSetRegistry reg = this.groupedTypesByCheckType.get(checkType);
        return reg == null ? Collections.EMPTY_SET : reg.getGroupedTypes(groupType);
    }

    @Override
    public <I> void addToGroups(Class<I> itemType, Class<? super I> ... groupTypes) {
        this.lock.lock();
        for (Class<? super I> groupType : groupTypes) {
            this.createGroup(groupType);
        }
        this.groupedTypes.addToGroups(itemType, groupTypes);
        this.lock.unlock();
    }

    @Override
    public <I> void addToGroups(CheckType checkType, Class<I> itemType, Class<? super I> ... groupTypes) {
        this.lock.lock();
        for (Class<? super I> groupType : groupTypes) {
            this.createGroup(groupType);
        }
        TypeSetRegistry reg = this.groupedTypesByCheckType.get(checkType);
        if (reg == null) {
            reg = new TypeSetRegistry(this.lock);
            this.updateRegistry(reg);
            this.groupedTypesByCheckType.put(checkType, reg);
        }
        reg.addToGroups(itemType, groupTypes);
        this.groupedTypes.addToGroups(itemType, groupTypes);
        this.lock.unlock();
    }

    @Override
    public void addToExistingGroups(Class<?> itemType) {
        this.groupedTypes.addToExistingGroups(itemType);
    }

    @Override
    public <I> void addToExistingGroups(CheckType checkType, Class<I> itemType) {
        this.lock.lock();
        TypeSetRegistry reg = this.groupedTypesByCheckType.get(checkType);
        if (reg == null) {
            reg = new TypeSetRegistry(this.lock);
            this.updateRegistry(reg);
            this.groupedTypesByCheckType.put(checkType, reg);
        }
        reg.addToExistingGroups(itemType);
        this.groupedTypes.addToExistingGroups(itemType);
        this.lock.unlock();
    }

    private void updateRegistry(TypeSetRegistry reg) {
        reg.updateGroupTypes(this.groupedTypes);
    }

    @Override
    public <G> void createGroup(Class<G> groupType) {
        this.groupedTypes.createGroup(groupType);
        for (Map.Entry<CheckType, TypeSetRegistry> entry : this.groupedTypesByCheckType.iterable()) {
            entry.getValue().createGroup(groupType);
        }
    }

    @Override
    public <I> void addToGroups(Collection<CheckType> checkTypes, Class<I> itemType, Class<? super I> ... groupTypes) {
        this.lock.lock();
        for (CheckType checkType : checkTypes) {
            this.addToGroups(checkType, itemType, groupTypes);
        }
        this.lock.unlock();
    }

    @Override
    public <I> void addToExistingGroups(Collection<CheckType> checkTypes, Class<I> itemType) {
        this.lock.lock();
        for (CheckType checkType : checkTypes) {
            this.addToExistingGroups(checkType, itemType);
        }
        this.lock.unlock();
    }
}

