/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.factory;

import fr.neatmonster.nocheatplus.components.concurrent.IPrimaryThreadContextTester;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOneRegistry;
import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import java.util.concurrent.locks.Lock;

public class FactoryOneRegistry<A>
implements IFactoryOneRegistry<A> {
    private final Lock lock;
    private final IPrimaryThreadContextTester primaryThreadContextTester;
    private final HashMapLOW<Class<?>, IFactoryOne<A, ?>> factories;

    public FactoryOneRegistry(Lock lock, IPrimaryThreadContextTester primaryThreadContextTester) {
        this.lock = lock;
        this.primaryThreadContextTester = primaryThreadContextTester;
        this.factories = new HashMapLOW(lock, 30);
    }

    @Override
    public <T> void registerFactory(Class<T> registerFor, IFactoryOne<A, T> factory) {
        if (!this.primaryThreadContextTester.isPrimaryThread()) {
            this.outsideThreadContext("register factory");
        }
        this.lock.lock();
        this.factories.put(registerFor, factory);
        this.lock.unlock();
    }

    private void outsideThreadContext(String tag) {
        throw new IllegalStateException("Can't call off the primary thread context: " + tag);
    }

    @Override
    public <T> T getNewInstance(Class<T> registeredFor, A arg) {
        Object instance;
        IFactoryOne<A, ?> factory = this.factories.get(registeredFor);
        if (factory == null) {
            return null;
        }
        this.lock.lock();
        try {
            instance = factory.getNewInstance(arg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
        return (T)instance;
    }
}

