/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.data.checktype;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.components.config.value.AlmostBooleanWithOverride;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.components.data.checktype.CheckTypeTree;
import fr.neatmonster.nocheatplus.config.ConfigFile;

public abstract class BaseCheckNode<N extends BaseCheckNode<N>>
extends CheckTypeTree.CheckTypeTreeNode<N> {
    protected OverrideType configOverrideType = OverrideType.DEFAULT;

    public BaseCheckNode(CheckType checkType, N parent, CheckTypeTree.CheckTypeTreeNodeFactory<N> factory) {
        super(checkType, parent, factory);
    }

    protected void override(AlmostBoolean active, OverrideType overrideType, boolean overrideChildren, IConfigFlagAccess<N> access) {
        block4: {
            boolean applicable;
            block3: {
                applicable = access.getConfigState(this).setValue(active, overrideType);
                if (applicable) {
                    this.update(false, access);
                }
                if (!overrideChildren) break block3;
                for (BaseCheckNode child : this.getChildren()) {
                    child.override(active, overrideType, true, access);
                }
                break block4;
            }
            if (!applicable) break block4;
            for (BaseCheckNode child : this.getChildren()) {
                if (access.getConfigState(child).getValue() != AlmostBoolean.MAYBE) continue;
                child.update(false, access);
            }
        }
    }

    protected void update(boolean forceUpdateChildren, IConfigFlagAccess<N> access) {
        BaseCheckNode thisNode = this;
        boolean previousActive = access.getState(thisNode);
        AlmostBooleanWithOverride configActivation = access.getConfigState(thisNode);
        AlmostBoolean newActive = (AlmostBoolean)((Object)configActivation.getValue());
        if (newActive != AlmostBoolean.MAYBE) {
            access.setState(thisNode, newActive.decide());
        } else if (newActive == AlmostBoolean.MAYBE) {
            BaseCheckNode parent = (BaseCheckNode)this.getParent();
            if (parent == null) {
                access.setState(thisNode, access.getMissingParentState());
            } else {
                access.setState(thisNode, access.getState(parent));
            }
        } else {
            access.setState(thisNode, newActive.decide());
        }
        if (forceUpdateChildren || previousActive != access.getState(thisNode)) {
            for (BaseCheckNode node : this.getChildren()) {
                if (!forceUpdateChildren && access.getConfigState(node).getValue() != AlmostBoolean.MAYBE) continue;
                node.update(forceUpdateChildren, access);
            }
        }
    }

    protected void update(ConfigFile rawConfiguration, boolean forceUpdateChildren, IConfigFlagAccess<N> access) {
        block4: {
            boolean changed;
            block3: {
                BaseCheckNode thisNode = this;
                AlmostBooleanWithOverride configActivation = access.getConfigState(thisNode);
                if (rawConfiguration != null && configActivation.allowsOverrideBy(OverrideType.SPECIFIC)) {
                    String configPath = access.getConfigPath(thisNode);
                    AlmostBoolean setValue = configPath == null ? AlmostBoolean.MAYBE : rawConfiguration.getAlmostBoolean(configPath, AlmostBoolean.MAYBE);
                    configActivation.setValue(setValue, this.configOverrideType);
                }
                boolean oldState = access.getState(thisNode);
                this.update(false, access);
                changed = oldState ^ access.getState(thisNode);
                if (!forceUpdateChildren) break block3;
                for (BaseCheckNode node : this.getChildren()) {
                    node.update(rawConfiguration, forceUpdateChildren, access);
                }
                break block4;
            }
            if (!changed) break block4;
            for (BaseCheckNode node : this.getChildren()) {
                if (access.getConfigState(node).getValue() != AlmostBoolean.MAYBE) continue;
                node.update(false, access);
            }
        }
    }

    protected static interface IConfigFlagAccess<N> {
        public AlmostBooleanWithOverride getConfigState(N var1);

        public boolean getState(N var1);

        public void setState(N var1, boolean var2);

        public String getConfigPath(N var1);

        public boolean getMissingParentState();
    }
}

