/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.spigotcb1_8_R2;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.spigotcb1_8_R2.BlockCacheSpigotCB1_8_R2;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import net.minecraft.server.v1_8_R2.AxisAlignedBB;
import net.minecraft.server.v1_8_R2.Block;
import net.minecraft.server.v1_8_R2.DamageSource;
import net.minecraft.server.v1_8_R2.EntityComplexPart;
import net.minecraft.server.v1_8_R2.EntityPlayer;
import net.minecraft.server.v1_8_R2.MobEffectList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.craftbukkit.v1_8_R2.CraftServer;
import org.bukkit.craftbukkit.v1_8_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R2.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MCAccessSpigotCB1_8_R2
implements MCAccess {
    public MCAccessSpigotCB1_8_R2() {
        this.getCommandMap();
        ReflectionUtil.checkMembers("net.minecraft.server.v1_8_R2.", new String[][]{{"Entity", "dead"}});
        ReflectionUtil.checkMethodReturnTypesNoArgs(Block.class, new String[]{"B", "C", "D", "E", "F", "G"}, Double.TYPE);
    }

    @Override
    public String getMCVersion() {
        return "1.8.3";
    }

    @Override
    public String getServerVersionTag() {
        return "Spigot-CB-1.8_R2";
    }

    @Override
    public CommandMap getCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public BlockCache getBlockCache() {
        return this.getBlockCache(null);
    }

    @Override
    public BlockCache getBlockCache(World world) {
        return new BlockCacheSpigotCB1_8_R2(world);
    }

    @Override
    public double getHeight(Entity entity) {
        net.minecraft.server.v1_8_R2.Entity mcEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB boundingBox = mcEntity.getBoundingBox();
        double entityHeight = Math.max((double)mcEntity.length, Math.max((double)mcEntity.getHeadHeight(), boundingBox.e - boundingBox.b));
        if (entity instanceof LivingEntity) {
            return Math.max(((LivingEntity)entity).getEyeHeight(), entityHeight);
        }
        return entityHeight;
    }

    @Override
    public AlmostBoolean isBlockSolid(Material id) {
        Block block = Block.getById((int)id.getId());
        if (block == null || block.getMaterial() == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.getMaterial().isSolid());
    }

    @Override
    public AlmostBoolean isBlockLiquid(Material id) {
        Block block = Block.getById((int)id.getId());
        if (block == null || block.getMaterial() == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.getMaterial().isLiquid());
    }

    @Override
    public double getWidth(Entity entity) {
        return ((CraftEntity)entity).getHandle().width;
    }

    @Override
    public AlmostBoolean isIllegalBounds(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.dead) {
            return AlmostBoolean.NO;
        }
        AxisAlignedBB box = entityPlayer.getBoundingBox();
        if (LocUtil.isBadCoordinate(box.a, box.b, box.c, box.d, box.e, box.f)) {
            return AlmostBoolean.YES;
        }
        if (!entityPlayer.isSleeping()) {
            double dY = Math.abs(box.e - box.b);
            if (dY > 1.8) {
                return AlmostBoolean.YES;
            }
            if (dY < 0.1 && (double)entityPlayer.length >= 0.1) {
                return AlmostBoolean.YES;
            }
        }
        return AlmostBoolean.MAYBE;
    }

    @Override
    public double getJumpAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.JUMP)) {
            return mcPlayer.getEffect(MobEffectList.JUMP).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getFasterMovementAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.FASTER_MOVEMENT)) {
            return mcPlayer.getEffect(MobEffectList.FASTER_MOVEMENT).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public int getInvulnerableTicks(Player player) {
        return ((CraftPlayer)player).getHandle().invulnerableTicks;
    }

    @Override
    public void setInvulnerableTicks(Player player, int ticks) {
        ((CraftPlayer)player).getHandle().invulnerableTicks = ticks;
    }

    @Override
    public void dealFallDamage(Player player, double damage) {
        ((CraftPlayer)player).getHandle().damageEntity(DamageSource.FALL, (float)damage);
    }

    @Override
    public boolean isComplexPart(Entity entity) {
        return ((CraftEntity)entity).getHandle() instanceof EntityComplexPart;
    }

    @Override
    public boolean shouldBeZombie(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        return !mcPlayer.dead && mcPlayer.getHealth() <= 0.0f;
    }

    @Override
    public void setDead(Player player, int deathTicks) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        mcPlayer.deathTicks = deathTicks;
        mcPlayer.dead = true;
    }

    @Override
    public boolean hasGravity(Material mat) {
        return mat.hasGravity();
    }

    @Override
    public AlmostBoolean dealFallDamageFiresAnEvent() {
        return AlmostBoolean.YES;
    }
}

