/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cb3100;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.cb3100.BlockCacheCB3100;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import net.minecraft.server.v1_7_R4.AxisAlignedBB;
import net.minecraft.server.v1_7_R4.Block;
import net.minecraft.server.v1_7_R4.DamageSource;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityComplexPart;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.MobEffectList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MCAccessCB3100
implements MCAccess {
    public MCAccessCB3100() {
        this.getCommandMap();
        ReflectionUtil.checkMembers("net.minecraft.server.v1_7_R4.", new String[][]{{"Entity", "dead"}});
        ReflectionUtil.checkMethodReturnTypesNoArgs(Block.class, new String[]{"x", "y", "z", "A", "B", "C"}, Double.TYPE);
    }

    @Override
    public String getMCVersion() {
        return "1.7.10";
    }

    @Override
    public String getServerVersionTag() {
        return "CB3100";
    }

    @Override
    public CommandMap getCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public BlockCache getBlockCache() {
        return this.getBlockCache(null);
    }

    @Override
    public BlockCache getBlockCache(World world) {
        return new BlockCacheCB3100(world);
    }

    @Override
    public double getHeight(org.bukkit.entity.Entity entity) {
        Entity mcEntity = ((CraftEntity)entity).getHandle();
        double entityHeight = Math.max((double)mcEntity.length, Math.max((double)mcEntity.height, mcEntity.boundingBox.e - mcEntity.boundingBox.b));
        if (entity instanceof LivingEntity) {
            return Math.max(((LivingEntity)entity).getEyeHeight(), entityHeight);
        }
        return entityHeight;
    }

    @Override
    public AlmostBoolean isBlockSolid(Material id) {
        Block block = Block.getById((int)id.getId());
        if (block == null || block.getMaterial() == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.getMaterial().isSolid());
    }

    @Override
    public AlmostBoolean isBlockLiquid(Material id) {
        Block block = Block.getById((int)id.getId());
        if (block == null || block.getMaterial() == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.getMaterial().isLiquid());
    }

    @Override
    public double getWidth(org.bukkit.entity.Entity entity) {
        return ((CraftEntity)entity).getHandle().width;
    }

    @Override
    public AlmostBoolean isIllegalBounds(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.dead) {
            return AlmostBoolean.NO;
        }
        AxisAlignedBB box = entityPlayer.boundingBox;
        if (LocUtil.isBadCoordinate(box.a, box.b, box.c, box.d, box.e, box.f)) {
            return AlmostBoolean.YES;
        }
        if (!entityPlayer.isSleeping()) {
            double dY = Math.abs(box.e - box.b);
            if (dY > 1.8) {
                return AlmostBoolean.YES;
            }
            if (dY < 0.1 && (double)entityPlayer.length >= 0.1) {
                return AlmostBoolean.YES;
            }
        }
        return AlmostBoolean.MAYBE;
    }

    @Override
    public double getJumpAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.JUMP)) {
            return mcPlayer.getEffect(MobEffectList.JUMP).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getFasterMovementAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.FASTER_MOVEMENT)) {
            return mcPlayer.getEffect(MobEffectList.FASTER_MOVEMENT).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public int getInvulnerableTicks(Player player) {
        return ((CraftPlayer)player).getHandle().invulnerableTicks;
    }

    @Override
    public void setInvulnerableTicks(Player player, int ticks) {
        ((CraftPlayer)player).getHandle().invulnerableTicks = ticks;
    }

    @Override
    public void dealFallDamage(Player player, double damage) {
        ((CraftPlayer)player).getHandle().damageEntity(DamageSource.FALL, (float)damage);
    }

    @Override
    public boolean isComplexPart(org.bukkit.entity.Entity entity) {
        return ((CraftEntity)entity).getHandle() instanceof EntityComplexPart;
    }

    @Override
    public boolean shouldBeZombie(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        return !mcPlayer.dead && mcPlayer.getHealth() <= 0.0f;
    }

    @Override
    public void setDead(Player player, int deathTicks) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        mcPlayer.deathTicks = deathTicks;
        mcPlayer.dead = true;
    }

    @Override
    public boolean hasGravity(Material mat) {
        return mat.hasGravity();
    }

    @Override
    public AlmostBoolean dealFallDamageFiresAnEvent() {
        return AlmostBoolean.YES;
    }
}

