/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;

public class BukkitFence
implements BukkitShapeModel {
    private final double minXZ;
    private final double maxXZ;
    private final double height;

    public BukkitFence(double inset, double height) {
        this(inset, 1.0 - inset, height);
    }

    public BukkitFence(double minXZ, double maxXZ, double height) {
        this.minXZ = minXZ;
        this.maxXZ = maxXZ;
        this.height = height;
    }

    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        if (blockData instanceof MultipleFacing) {
            MultipleFacing fence = (MultipleFacing)blockData;
            double[] res = new double[]{this.minXZ, 0.0, this.minXZ, this.maxXZ, this.height, this.maxXZ};
            for (BlockFace face : fence.getFaces()) {
                switch (face) {
                    case EAST: {
                        res[3] = 1.0;
                        break;
                    }
                    case NORTH: {
                        res[2] = 0.0;
                        break;
                    }
                    case WEST: {
                        res[0] = 0.0;
                        break;
                    }
                    case SOUTH: {
                        res[5] = 1.0;
                        break;
                    }
                }
            }
            return res;
        }
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        return 0;
    }
}

