/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.compat.BridgeMaterial;
import fr.neatmonster.nocheatplus.compat.blocks.init.BlockInit;
import fr.neatmonster.nocheatplus.compat.bukkit.BlockCacheBukkitModern;
import fr.neatmonster.nocheatplus.compat.bukkit.MCAccessBukkit;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitDirectionalCentered;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitDoor;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitEndPortalFrame;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitFence;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitGate;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShulkerBox;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitSlab;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitStairs;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitStatic;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitTrapDoor;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;

public class MCAccessBukkitModern
extends MCAccessBukkit {
    protected final Map<Material, BukkitShapeModel> shapeModels = new HashMap<Material, BukkitShapeModel>();
    private static final BukkitShapeModel MODEL_DOOR = new BukkitDoor();
    private static final BukkitShapeModel MODEL_TRAP_DOOR = new BukkitTrapDoor();
    private static final BukkitShapeModel MODEL_GATE = new BukkitGate(0.375, 1.5);
    private static final BukkitShapeModel MODEL_SHULKER_BOX = new BukkitShulkerBox();
    private static final BukkitShapeModel MODEL_END_PORTAL_FRAME = new BukkitEndPortalFrame();
    private static final BukkitShapeModel MODEL_SLAB = new BukkitSlab();
    private static final BukkitShapeModel MODEL_STAIRS = new BukkitStairs();
    private static final BukkitShapeModel MODEL_END_ROD = new BukkitDirectionalCentered(0.375, 1.0, false);
    private static final BukkitShapeModel MODEL_THIN_FENCE = new BukkitFence(0.4375, 1.0);
    private static final BukkitShapeModel MODEL_THICK_FENCE = new BukkitFence(0.375, 1.5);
    private static final BukkitShapeModel MODEL_LILY_PAD = new BukkitStatic(0.09375);
    private static final BukkitShapeModel MODEL_FLOWER_POT = new BukkitStatic(0.33, 0.375);
    private static final BukkitShapeModel MODEL_GROUND_HEAD = new BukkitStatic(0.25, 0.5);
    private static final BukkitShapeModel MODEL_SINGLE_CHEST = new BukkitStatic(0.062, 0.875);
    private static final BukkitShapeModel MODEL_INSET16_1_HEIGHT100 = new BukkitStatic(0.0625, 1.0);
    private static final BukkitShapeModel MODEL_XZ100_HEIGHT16_1 = new BukkitStatic(0.0625);
    private static final BukkitShapeModel MODEL_XZ100_HEIGHT8_1 = new BukkitStatic(0.125);
    private static final BukkitShapeModel MODEL_XZ100_HEIGHT8_3 = new BukkitStatic(0.375);
    private static final BukkitShapeModel MODEL_XZ100_HEIGHT16_9 = new BukkitStatic(0.5625);
    private static final BukkitShapeModel MODEL_XZ100_HEIGHT4_3 = new BukkitStatic(0.75);
    private static final BukkitShapeModel MODEL_XZ100_HEIGHT8_7 = new BukkitStatic(0.875);
    private static final BukkitShapeModel MODEL_XZ100_HEIGHT16_15 = new BukkitStatic(0.9375);

    public MCAccessBukkitModern() {
        BlockInit.assertMaterialExists("OAK_LOG");
        BlockInit.assertMaterialExists("CAVE_AIR");
    }

    @Override
    public String getMCVersion() {
        return "1.13|?";
    }

    @Override
    public BlockCache getBlockCache() {
        return new BlockCacheBukkitModern(this.shapeModels);
    }

    public void addModel(Material mat, BukkitShapeModel model) {
        this.processedBlocks.add(mat);
        this.shapeModels.put(mat, model);
    }

    @Override
    public void setupBlockProperties(WorldConfigProvider<?> worldConfigProvider) {
        BlockProperties.setBlockFlags(Material.CAULDRON, BlockFlags.SOLID_GROUND | BlockProperties.F_GROUND_HEIGHT | BlockProperties.F_MIN_HEIGHT4_1);
        for (Object mat : new Material[]{Material.CAULDRON, BridgeMaterial.COBWEB, Material.HOPPER, BridgeMaterial.MOVING_PISTON, Material.SNOW}) {
            this.processedBlocks.add(mat);
        }
        this.addModel(BridgeMaterial.LILY_PAD, MODEL_LILY_PAD);
        this.addModel(BridgeMaterial.END_PORTAL_FRAME, MODEL_END_PORTAL_FRAME);
        this.addModel(Material.END_ROD, MODEL_END_ROD);
        for (Object mat : new Material[]{Material.CACTUS, Material.DRAGON_EGG}) {
            this.addModel((Material)mat, MODEL_INSET16_1_HEIGHT100);
        }
        for (Object mat : new Material[]{BridgeMaterial.REPEATER, Material.COMPARATOR}) {
            this.addModel((Material)mat, MODEL_XZ100_HEIGHT8_1);
        }
        for (Object mat : new Material[]{Material.DAYLIGHT_DETECTOR}) {
            this.addModel((Material)mat, MODEL_XZ100_HEIGHT8_3);
        }
        for (Object mat : new Material[]{BridgeMaterial.ENCHANTING_TABLE}) {
            this.addModel((Material)mat, MODEL_XZ100_HEIGHT4_3);
        }
        for (Object mat : new Material[]{Material.BREWING_STAND}) {
            this.addModel((Material)mat, MODEL_XZ100_HEIGHT8_7);
        }
        for (Object mat : new Material[]{Material.GRASS_PATH, BridgeMaterial.FARMLAND}) {
            this.addModel((Material)mat, MODEL_XZ100_HEIGHT16_15);
        }
        for (Material mat : MaterialUtil.addBlocks(MaterialUtil.GLASS_PANES, BridgeMaterial.IRON_BARS)) {
            this.addModel(mat, MODEL_THIN_FENCE);
        }
        for (Material mat : MaterialUtil.SLABS) {
            this.addModel(mat, MODEL_SLAB);
        }
        for (Material mat : MaterialUtil.SHULKER_BOXES) {
            this.addModel(mat, MODEL_SHULKER_BOX);
        }
        for (Material mat : BridgeMaterial.getAllBlocks("chest", "trapped_chest", "ender_chest")) {
            this.addModel(mat, MODEL_SINGLE_CHEST);
        }
        for (Material mat : MaterialUtil.BEDS) {
            this.addModel(mat, MODEL_XZ100_HEIGHT16_9);
        }
        for (Material mat : MaterialUtil.FLOWER_POTS) {
            this.addModel(mat, MODEL_FLOWER_POT);
        }
        for (Material mat : MaterialUtil.CARPETS) {
            this.addModel(mat, MODEL_XZ100_HEIGHT16_1);
        }
        for (Material mat : MaterialUtil.HEADS_GROUND) {
            this.addModel(mat, MODEL_GROUND_HEAD);
        }
        for (Material mat : MaterialUtil.ALL_DOORS) {
            this.addModel(mat, MODEL_DOOR);
        }
        for (Material mat : MaterialUtil.ALL_TRAP_DOORS) {
            this.addModel(mat, MODEL_TRAP_DOOR);
        }
        for (Object mat : Material.values()) {
            long flags = BlockProperties.getBlockFlags(mat);
            if (BlockFlags.hasAnyFlag(flags, BlockProperties.F_STAIRS)) {
                this.addModel((Material)mat, MODEL_STAIRS);
            }
            if (!BlockFlags.hasAnyFlag(flags, BlockProperties.F_THICK_FENCE)) continue;
            if (BlockFlags.hasAnyFlag(flags, BlockProperties.F_PASSABLE_X4)) {
                this.addModel((Material)mat, MODEL_GATE);
                continue;
            }
            this.addModel((Material)mat, MODEL_THICK_FENCE);
        }
        super.setupBlockProperties(worldConfigProvider);
    }
}

