/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.init;

import fr.neatmonster.nocheatplus.compat.BridgeMaterial;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Material;

public class BlockInit {
    public static void assertMaterialExists(String id) {
        if (BlockProperties.getMaterial(id) == null) {
            throw new RuntimeException("Material " + id + " does not exist.");
        }
    }

    public static Material getMaterial(String name) {
        try {
            return Material.matchMaterial((String)name.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setPropsAs(Material newMat, Material mat) {
        BlockProperties.setBlockProps(newMat, BlockProperties.getBlockProps(mat));
    }

    public static void setPropsAs(String newId, Material mat) {
        BlockProperties.setBlockProps(newId, BlockProperties.getBlockProps(mat));
    }

    public static void setPropsAs(String newId, String otherId) {
        BlockProperties.setBlockProps(newId, BlockProperties.getBlockProps(otherId));
    }

    public static void setAs(Material newMat, Material mat) {
        BlockFlags.setFlagsAs(newMat, mat);
        BlockInit.setPropsAs(newMat, mat);
    }

    public static void setAs(String newId, Material mat) {
        BlockFlags.setFlagsAs(newId, mat);
        BlockInit.setPropsAs(newId, mat);
    }

    public static void setAs(String newId, String otherId) {
        BlockFlags.setFlagsAs(newId, otherId);
        BlockInit.setPropsAs(newId, otherId);
    }

    public static void setInstantPassable(String newId) {
        BlockProperties.setBlockFlags(newId, BlockProperties.F_IGN_PASSABLE);
        BlockProperties.setBlockProps(newId, BlockProperties.instantType);
    }

    public static void setInstantPassable(Material newId) {
        BlockProperties.setBlockFlags(newId, BlockProperties.F_IGN_PASSABLE);
        BlockProperties.setBlockProps(newId, BlockProperties.instantType);
    }

    public static void setAsIfExists(String newName, Material mat) {
        if (BridgeMaterial.has(newName)) {
            BlockInit.setAs(newName, mat);
        }
    }

    public static void setAsIfExists(String newName, String otherName) {
        if (BridgeMaterial.has(newName)) {
            BlockInit.setAs(newName, otherName);
        }
    }
}

