/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat;

import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMaterial;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BridgeMisc {
    public static final GameMode GAME_MODE_SPECTATOR = BridgeMisc.getSpectatorGameMode();
    private static final Method Bukkit_getOnlinePlayers = ReflectionUtil.getMethodNoArgs(Bukkit.class, "getOnlinePlayers", new Class[0]);
    public static final PlayerTeleportEvent.TeleportCause TELEPORT_CAUSE_CORRECTION_OF_POSITION = PlayerTeleportEvent.TeleportCause.UNKNOWN;

    private static GameMode getSpectatorGameMode() {
        try {
            return GameMode.SPECTATOR;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Player getShooterPlayer(Projectile projectile) {
        Object source;
        try {
            source = projectile.getClass().getMethod("getShooter", new Class[0]).invoke((Object)projectile, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (source instanceof Player) {
            return (Player)source;
        }
        return null;
    }

    public static Player getAttackingPlayer(Entity damager) {
        if (damager instanceof Player) {
            return (Player)damager;
        }
        if (damager instanceof Projectile) {
            return BridgeMisc.getShooterPlayer((Projectile)damager);
        }
        return null;
    }

    public static Player[] getOnlinePlayers() {
        try {
            Collection players = Bukkit.getOnlinePlayers();
            return players.isEmpty() ? new Player[]{} : players.toArray(new Player[players.size()]);
        }
        catch (NoSuchMethodError players) {
            Object obj;
            if (Bukkit_getOnlinePlayers != null && (obj = ReflectionUtil.invokeMethodNoArgs(Bukkit_getOnlinePlayers, null)) != null && obj instanceof Player[]) {
                return (Player[])obj;
            }
            return new Player[0];
        }
    }

    public static boolean maybeElytraBoost(Player player, Material materialInHand) {
        return BridgeMaterial.FIREWORK_ROCKET != null && materialInHand == BridgeMaterial.FIREWORK_ROCKET && Bridge1_9.isGlidingWithElytra(player);
    }

    public static int getFireworksPower(ItemStack item) {
        if (item == null || item.getType() != BridgeMaterial.FIREWORK_ROCKET) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof FireworkMeta)) {
            return 0;
        }
        FireworkMeta fwMeta = (FireworkMeta)meta;
        return fwMeta.getPower();
    }
}

