/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin.debug;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.IdUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class DebugPlayerCommand
extends BaseCommand {
    public DebugPlayerCommand(JavaPlugin plugin) {
        super(plugin, "player", (RegisteredPermission)null);
        this.usage = "/ncp debug player ... online player name or UUID, ?(yes|no|default)[:CheckType1[:CheckType2...]] to set the default behavior - mix with player names/ids.";
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        DebugEntry entry = new DebugEntry();
        for (int i = 2; i < args.length; ++i) {
            Player player;
            String input = args[i];
            if (input.startsWith("?")) {
                entry = DebugEntry.parseEntry(input.substring(1));
                if (entry != null) continue;
                sender.sendMessage("Bad setup: " + input);
                return true;
            }
            String name = input;
            if (IdUtil.isValidMinecraftUserName(name)) {
                player = DataManager.getPlayer(name);
            } else {
                UUID id = IdUtil.UUIDFromStringSafe(input);
                if (id == null) {
                    sender.sendMessage("Bad name or UUID: " + input);
                    continue;
                }
                player = DataManager.getPlayer(id);
            }
            if (player == null) {
                sender.sendMessage("Not online: " + name);
                continue;
            }
            Collection<CheckType> checkTypes = entry.checkTypes.isEmpty() ? Arrays.asList(CheckType.ALL) : entry.checkTypes;
            IPlayerData data = DataManager.getPlayerData(player);
            for (CheckType checkType : checkTypes) {
                if (entry.active == AlmostBoolean.MAYBE) {
                    data.resetDebug(checkType);
                    continue;
                }
                data.overrideDebug(checkType, entry.active, OverrideType.CUSTOM, true);
            }
            sender.sendMessage("Set debug = " + (Object)((Object)entry.active) + " for player " + player.getName() + " for checks: " + StringUtil.join(checkTypes, ","));
        }
        return true;
    }

    static class DebugEntry {
        public AlmostBoolean active = AlmostBoolean.YES;
        public final Set<CheckType> checkTypes = new LinkedHashSet<CheckType>();

        DebugEntry() {
        }

        public static DebugEntry parseEntry(String input) {
            String[] split = input.split(":");
            DebugEntry entry = new DebugEntry();
            entry.active = AlmostBoolean.match(split[0]);
            if (entry.active == null) {
                return null;
            }
            for (int i = 1; i < split.length; ++i) {
                try {
                    CheckType checkType = CheckType.valueOf(split[i].toUpperCase().replace('.', '_'));
                    if (checkType == null) {
                        return null;
                    }
                    entry.checkTypes.add(checkType);
                    continue;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return entry;
        }
    }
}

