/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.CountableLocation;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class OutgoingPosition
extends BaseAdapter {
    public static final int indexX = 0;
    public static final int indexY = 1;
    public static final int indexZ = 2;
    public static final int indexYaw = 0;
    public static final int indexPitch = 1;
    private final Integer ID_OUTGOING_POSITION_UNTRACKED;
    private boolean hasTeleportId;

    public OutgoingPosition(Plugin plugin) {
        super(plugin, ListenerPriority.HIGHEST, PacketType.Play.Server.POSITION);
        this.ID_OUTGOING_POSITION_UNTRACKED = this.counters.registerKey("packet.outgoing_position.untracked");
        this.hasTeleportId = true;
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        if (pData.isCheckActive(CheckType.NET_FLYINGFREQUENCY, player)) {
            this.interpretPacket(player, event.getPacket(), time, pData.getGenericInstance(NetData.class), pData.isDebugActive(CheckType.NET_FLYINGFREQUENCY));
        }
    }

    private void interpretPacket(Player player, PacketContainer packet, long time, NetData data, boolean debug) {
        CountableLocation packetData;
        StructureModifier doubles = packet.getDoubles();
        StructureModifier floats = packet.getFloat();
        if (doubles.size() != 3 || floats.size() != 2) {
            this.packetMismatch(packet);
            return;
        }
        double x = (Double)doubles.read(0);
        double y = (Double)doubles.read(1);
        double z = (Double)doubles.read(2);
        float yaw = ((Float)floats.read(0)).floatValue();
        float pitch = ((Float)floats.read(1)).floatValue();
        Integer teleportId = Integer.MIN_VALUE;
        if (this.hasTeleportId) {
            try {
                StructureModifier integers = packet.getIntegers();
                if (integers.size() == 1) {
                    teleportId = (Integer)integers.read(0);
                    if (teleportId == null) {
                        teleportId = Integer.MIN_VALUE;
                    }
                    if (teleportId != Integer.MIN_VALUE && debug) {
                        this.debug(player, "Outgoing confirm teleport id: " + teleportId);
                    }
                } else {
                    this.hasTeleportId = false;
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "PacketPlayOutPosition: Teleport confirm id not available, field mismatch: " + integers.size());
                }
            }
            catch (Throwable t) {
                this.hasTeleportId = false;
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "PacketPlayOutPosition: Teleport confirm id not available.");
            }
        }
        if ((packetData = data.teleportQueue.onOutgoingTeleport(x, y, z, yaw, pitch, teleportId)) == null) {
            this.counters.add(this.ID_OUTGOING_POSITION_UNTRACKED, 1);
            if (debug) {
                this.debug(player, "Untracked outgoing position: " + x + ", " + y + ", " + z + " (yaw=" + yaw + ", pitch=" + pitch + ").");
            }
        } else if (debug) {
            this.debug(player, "Expect ACK on outgoing position: " + packetData);
        }
    }

    private void packetMismatch(PacketContainer packet) {
    }
}

