/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.util;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.player.PlayerSetBackMethod;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.CountableLocation;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.debug.IDebugPlayer;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;

public class MovingUtil {
    private static final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public static final boolean shouldCheckSurvivalFly(Player player, PlayerLocation fromLocation, MovingData data, MovingConfig cc, IPlayerData pData) {
        GameMode gameMode = player.getGameMode();
        return !(!pData.isCheckActive(CheckType.MOVING_SURVIVALFLY, player) || gameMode == BridgeMisc.GAME_MODE_SPECTATOR || !cc.ignoreCreative && gameMode == GameMode.CREATIVE || player.isFlying() || !cc.ignoreAllowFlight && player.getAllowFlight() || Bridge1_9.isGlidingWithElytra(player) && MovingUtil.isGlidingWithElytraValid(player, fromLocation, data, cc) || !Double.isInfinite(Bridge1_9.getLevitationAmplifier(player)) && !fromLocation.isInLiquid());
    }

    public static boolean isGlidingWithElytraValid(Player player, PlayerLocation fromLocation, MovingData data, MovingConfig cc) {
        PlayerMoveData firstPastMove = data.playerMoves.getFirstPastMove();
        if (!Bridge1_9.hasEntityToggleGlideEvent() && !firstPastMove.toIsValid || firstPastMove.modelFlying == null || !"jetpack.elytra".equals(firstPastMove.modelFlying.getId())) {
            return MovingUtil.canLiftOffWithElytra(player, fromLocation, data);
        }
        return data.fireworksBoostDuration > 0 || !BlockProperties.collides(fromLocation.getBlockCache(), fromLocation.getMinX(), fromLocation.getMinY(), fromLocation.getMinZ(), fromLocation.getMaxX(), fromLocation.getMinY() + 0.6, fromLocation.getMaxZ(), BlockProperties.F_COBWEB);
    }

    public static boolean canLiftOffWithElytra(Player player, PlayerLocation loc, MovingData data) {
        return loc.isPassableBox() && !loc.isInWeb() && !loc.isOnGround(0.001);
    }

    public static double getEyeHeight(Player player) {
        return Bridge1_9.isGlidingWithElytra(player) ? 0.4 : player.getEyeHeight();
    }

    public static void setElytraProperties(Player player, PlayerLocation pLoc, Location loc, double yOnGround, MCAccess mcAccess) {
        pLoc.set(loc, player, mcAccess.getWidth((Entity)player), 0.4, 0.6, 0.6, yOnGround);
    }

    public static void handleIllegalMove(PlayerMoveEvent event, Player player, MovingData data, MovingConfig cc) {
        boolean restored = false;
        PlayerLocation pLoc = new PlayerLocation(NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(MCAccess.class), null);
        Location loc = player.getLocation();
        if (!restored && data.hasSetBack()) {
            Location setBack = data.getSetBack(loc);
            pLoc.set(setBack, player);
            if (!(pLoc.hasIllegalCoords() || !cc.ignoreStance && pLoc.hasIllegalStance())) {
                event.setFrom(setBack);
                event.setTo(setBack);
                restored = true;
            } else {
                data.resetSetBack();
            }
        }
        if (!restored) {
            pLoc.set(loc, player);
            if (!(pLoc.hasIllegalCoords() || !cc.ignoreStance && pLoc.hasIllegalStance())) {
                event.setFrom(loc);
                event.setTo(loc);
                restored = true;
            }
        }
        pLoc.cleanup();
        if (!restored) {
            if (cc.tempKickIllegal) {
                NCPAPIProvider.getNoCheatPlusAPI().denyLogin(player.getName(), 86400000L);
                StaticLog.logSevere("[NCP] could not restore location for " + player.getName() + ", kicking them and deny login for 24 hours");
            } else {
                StaticLog.logSevere("[NCP] could not restore location for " + player.getName() + ", kicking them.");
            }
            CheckUtils.kickIllegalMove(player, cc);
        }
    }

    public static boolean canJumpOffTop(Material blockType) {
        return BlockProperties.isGround(blockType) || BlockProperties.isSolid(blockType);
    }

    public static boolean shouldCheckUntrackedLocation(Player player, Location loc, IPlayerData pData) {
        return !TrigUtil.isSamePos(loc, loc.getWorld().getSpawnLocation()) && !BlockProperties.isPassable(loc) && pData.isCheckActive(CheckType.MOVING_PASSABLE, player);
    }

    public static Location checkUntrackedLocation(Location loc) {
        Chunk toChunk = loc.getChunk();
        Entity[] entities = toChunk.getEntities();
        MovingData untrackedData = null;
        for (int i = 0; i < entities.length; ++i) {
            Location refLoc;
            Entity entity = entities[i];
            if (entity.getType() != EntityType.PLAYER || !TrigUtil.isSamePos(loc, refLoc = entity.getLocation(useLoc)) || !(entity instanceof Player)) continue;
            Player other = (Player)entity;
            IPlayerData otherPData = DataManager.getPlayerData(other);
            MovingData otherData = otherPData.getGenericInstance(MovingData.class);
            PlayerMoveData otherLastMove = otherData.playerMoves.getFirstPastMove();
            if (!otherLastMove.toIsValid) continue;
            if (TrigUtil.isSamePos(refLoc, otherLastMove.to.getX(), otherLastMove.to.getY(), otherLastMove.to.getZ())) {
                return null;
            }
            if (TrigUtil.isSameBlock(loc, otherLastMove.to.getX(), otherLastMove.to.getY(), otherLastMove.to.getZ()) && !BlockProperties.isPassable(refLoc.getWorld(), otherLastMove.to.getX(), otherLastMove.to.getY(), otherLastMove.to.getZ())) continue;
            untrackedData = otherData;
        }
        useLoc.setWorld(null);
        if (untrackedData == null) {
            return null;
        }
        PlayerMoveData lastMove = untrackedData.playerMoves.getFirstPastMove();
        return new Location(loc.getWorld(), lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ(), loc.getYaw(), loc.getPitch());
    }

    public static double getRealisticFallDistance(Player player, double fromY, double toY, MovingData data, IPlayerData pData) {
        if (pData.isCheckActive(CheckType.MOVING_NOFALL, player)) {
            if (data.noFallMaxY >= fromY) {
                return Math.max(0.0, data.noFallMaxY - toY);
            }
            return Math.max(0.0, fromY - toY);
        }
        return (double)player.getFallDistance() + Math.max(0.0, fromY - toY);
    }

    public static void checkSetBack(Player player, PlayerLocation from, MovingData data, IPlayerData pData, IDebugPlayer idp) {
        if (!data.hasSetBack()) {
            data.setSetBack(from);
        } else if (data.joinOrRespawn && from.getY() > data.getSetBackY() && TrigUtil.isSamePos(from.getX(), from.getZ(), data.getSetBackX(), data.getSetBackZ()) && (from.isOnGround() || from.isResetCond())) {
            if (pData.isDebugActive(CheckType.MOVING)) {
                idp.debug(player, "Adjust set back after join/respawn: " + from.getLocation());
            }
            data.setSetBack(from);
            data.resetPlayerPositions(from);
        }
    }

    public static double getJumpAmplifier(Player player, MCAccess mcAccess) {
        double amplifier = mcAccess.getJumpAmplifier(player);
        if (Double.isInfinite(amplifier)) {
            return 0.0;
        }
        return 1.0 + amplifier;
    }

    public static void prepareFullCheck(RichBoundsLocation from, RichBoundsLocation to, MoveData thisMove, double yOnGround) {
        from.collectBlockFlags(yOnGround);
        if (from.isSamePos(to)) {
            to.prepare(from);
        } else {
            to.collectBlockFlags(yOnGround);
        }
        thisMove.setExtraProperties(from, to);
    }

    public static void ensureChunksLoaded(Player player, Location from, Location to, PlayerMoveData lastMove, String tag, MovingConfig cc, IPlayerData pData) {
        double z1;
        double x1;
        double z0;
        double x0 = from.getX();
        if (TrigUtil.distanceSquared(x0, z0 = from.getZ(), x1 = to.getX(), z1 = to.getZ()) > 6.0) {
            return;
        }
        boolean loadFrom = true;
        boolean loadTo = true;
        double margin = 3.0;
        if (lastMove.toIsValid && lastMove.to.extraPropertiesValid) {
            if (TrigUtil.distanceSquared(lastMove.to, x0, z0) < 1.0) {
                loadFrom = false;
            }
            if (TrigUtil.distanceSquared(lastMove.to, x1, z1) < 1.0) {
                loadTo = false;
            }
        } else if (lastMove.valid && lastMove.from.extraPropertiesValid && cc.loadChunksOnJoin) {
            if (TrigUtil.distanceSquared(lastMove.from, x0, z0) < 1.0) {
                loadFrom = false;
            }
            if (TrigUtil.distanceSquared(lastMove.from, x1, z1) < 1.0) {
                loadTo = false;
            }
        }
        int loaded = 0;
        if (loadFrom) {
            loaded += MapUtil.ensureChunksLoaded(from.getWorld(), x0, z0, margin);
            if (TrigUtil.distanceSquared(x0, z0, x1, z1) < 1.0) {
                loadTo = false;
            }
        }
        if (loadTo) {
            loaded += MapUtil.ensureChunksLoaded(to.getWorld(), x1, z1, margin);
        }
        if (loaded > 0 && pData.isDebugActive(CheckType.MOVING)) {
            StaticLog.logInfo("Player " + tag + ": Loaded " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + from.getWorld().getName() + " for player: " + player.getName());
        }
    }

    public static void ensureChunksLoaded(Player player, Location loc, String tag, MovingData data, MovingConfig cc, IPlayerData pData) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        double x0 = loc.getX();
        double z0 = loc.getZ();
        if (lastMove.toIsValid && lastMove.to.extraPropertiesValid ? TrigUtil.distanceSquared(lastMove.to, x0, z0) < 1.0 : lastMove.valid && lastMove.from.extraPropertiesValid && cc.loadChunksOnJoin && TrigUtil.distanceSquared(lastMove.from, x0, z0) < 1.0) {
            return;
        }
        int loaded = MapUtil.ensureChunksLoaded(loc.getWorld(), loc.getX(), loc.getZ(), 3.0);
        if (loaded > 0 && pData.isDebugActive(CheckType.MOVING)) {
            StaticLog.logInfo("Player " + tag + ": Loaded " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " for player: " + player.getName());
        }
    }

    public static boolean hasScheduledPlayerSetBack(Player player) {
        return MovingUtil.hasScheduledPlayerSetBack(player.getUniqueId(), DataManager.getGenericInstance(player, MovingData.class));
    }

    public static boolean hasScheduledPlayerSetBack(UUID playerId, MovingData data) {
        return data.hasTeleported() && MovingUtil.isPlayersetBackScheduled(playerId);
    }

    private static boolean isPlayersetBackScheduled(UUID playerId) {
        IPlayerData pd = DataManager.getPlayerData(playerId);
        return pd != null && pd.isPlayerSetBackScheduled();
    }

    public static boolean processStoredSetBack(Player player, String debugMessagePrefix, IPlayerData pData) {
        CountableLocation cl;
        MovingData data = pData.getGenericInstance(MovingData.class);
        boolean debug = pData.isDebugActive(CheckType.MOVING);
        if (!data.hasTeleported()) {
            if (debug) {
                CheckUtils.debug(player, CheckType.MOVING, debugMessagePrefix + "No stored location available.");
            }
            return false;
        }
        Location loc = player.getLocation(useLoc);
        if (data.isTeleportedPosition(loc)) {
            if (debug) {
                CheckUtils.debug(player, CheckType.MOVING, debugMessagePrefix + "Skip teleport, player is there, already.");
            }
            data.resetTeleported();
            useLoc.setWorld(null);
            return false;
        }
        useLoc.setWorld(null);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        PlayerSetBackMethod method = cc.playerSetBackMethod;
        if (!method.shouldNoRisk() && (method.shouldCancel() || method.shouldSetTo()) && method.shouldUpdateFrom() && data.isTeleportedPosition(cl = pData.getGenericInstance(NetData.class).teleportQueue.getLastAck())) {
            if (debug) {
                CheckUtils.debug(player, CheckType.MOVING, debugMessagePrefix + "Skip teleport, having received an ACK for the teleport on packet level. Player is at: " + LocUtil.simpleFormat(loc));
            }
            return false;
        }
        Location teleported = data.getTeleported();
        if (player.teleport(teleported, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION)) {
            return true;
        }
        if (debug) {
            CheckUtils.debug(player, CheckType.MOVING, "Player set back on tick: Teleport failed.");
        }
        return false;
    }

    public static Location getApplicableSetBackLocation(Player player, float refYaw, float refPitch, PlayerLocation from, MovingData data, MovingConfig cc) {
        double[] groundSpec;
        boolean scanForVoid = false;
        if (cc.sfSetBackPolicyVoid) {
            if (from.getY() < 0.0) {
                return new Location(from.getWorld(), from.getX(), from.getY() - 0.0834, from.getZ(), from.getYaw(), from.getPitch());
            }
            scanForVoid = true;
        }
        if (scanForVoid && (groundSpec = MovingUtil.scanForGroundOrResetCond(player, from)) == null) {
            return new Location(from.getWorld(), from.getX(), -2.0, from.getZ(), from.getYaw(), from.getPitch());
        }
        if (data.hasSetBack()) {
            return data.getSetBack(refYaw, refPitch);
        }
        return null;
    }

    private static final double[] scanForGroundOrResetCond(Player player, PlayerLocation from) {
        if (from.isOnGroundOrResetCond()) {
            return new double[]{0.0, from.getyOnGround()};
        }
        double distToVoid = from.getY();
        if (distToVoid <= 0.0) {
            return null;
        }
        if (BlockProperties.collectFlagsSimple(from.getBlockCache(), from.getMinX(), 0.0, from.getMinZ(), from.getMaxX(), from.getMinY(), from.getMaxZ()) != 0L) {
            return new double[]{0.0, distToVoid};
        }
        return null;
    }
}

