/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.magic;

import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;

public class Magic {
    public static final double DEFAULT_WALKSPEED = 0.2;
    public static final double DEFAULT_FLYSPEED = 0.1;
    public static final double GRAVITY_MAX = 0.0834;
    public static final double GRAVITY_MIN = 0.0624;
    public static final double GRAVITY_SPAN = 0.021000000000000005;
    public static final double GRAVITY_ODD = 0.05;
    public static final float GRAVITY_VACC = 0.03744f;
    public static final double FRICTION_MEDIUM_AIR = 0.98;
    public static final double FRICTION_MEDIUM_WATER = 0.89;
    public static final double FRICTION_MEDIUM_LAVA = 0.535;
    public static final double WALK_SPEED = 0.221;
    public static final double modSneak = 0.5882352941176471;
    public static final double modBlock = 0.7239819004524887;
    public static final double modSwim = 0.5203619909502263;
    public static final double[] modDepthStrider = new double[]{1.0, 1.4304347826086956, 1.734782608695652, 1.9217391304347824};
    public static final double modWeb = 0.4751131221719457;
    public static final double modIce = 2.5;
    public static final double modDownStream = 1.6521739130434783;
    public static final double GLIDE_HORIZONTAL_GAIN_MAX = 0.0417;
    public static final double climbSpeedAscend = 0.119;
    public static final double climbSpeedDescend = 0.151;
    public static final double GLIDE_DESCEND_PHASE_MIN = -0.1044;
    public static final double GLIDE_DESCEND_GAIN_MAX_NEG = -0.0834;
    public static final double GLIDE_DESCEND_GAIN_MAX_POS = 0.025641025641025644;
    public static final double Y_ON_GROUND_MIN = 1.0E-5;
    public static final double Y_ON_GROUND_MAX = 0.0626;
    public static final double Y_ON_GROUND_DEFAULT = 0.016;
    public static final double FALL_DAMAGE_DIST = 3.0;
    public static final double FALL_DAMAGE_MINIMUM = 0.5;
    public static final double BOUNCE_VERTICAL_MAX_DIST = 3.5;
    public static final double PAPER_DIST = 0.01;
    public static final double EXTREME_MOVE_DIST_VERTICAL = 4.0;
    public static final double EXTREME_MOVE_DIST_HORIZONTAL = 22.0;
    public static final double CHUNK_LOAD_MARGIN_MIN = 3.0;

    public static double swimBaseSpeedV() {
        return 0.135;
    }

    public static boolean fallingEnvelope(double yDistance, double lastYDist, double lastFrictionVertical, double extraGravity) {
        if (yDistance >= lastYDist) {
            return false;
        }
        double frictDist = lastYDist * lastFrictionVertical - 0.0624;
        return yDistance <= frictDist + extraGravity && yDistance > frictDist - 0.021000000000000005 - extraGravity;
    }

    public static boolean enoughFrictionEnvelope(PlayerMoveData thisMove, PlayerMoveData lastMove, double friction, double minGravity, double maxOff, double decreaseByOff) {
        double frictDist = lastMove.yDistance * friction - minGravity;
        double off = Math.abs(thisMove.yDistance - frictDist);
        return off <= maxOff && Math.abs(thisMove.yDistance - lastMove.yDistance) <= off * decreaseByOff;
    }

    static boolean splashMove(PlayerMoveData thisMove, PlayerMoveData lastMove) {
        return !thisMove.touchedGround && thisMove.from.inWater && !thisMove.to.resetCond && !lastMove.touchedGround && !lastMove.from.resetCond && lastMove.to.inWater && Magic.excludeStaticSpeed(thisMove) && Magic.excludeStaticSpeed(lastMove);
    }

    static boolean splashMoveNonStrict(PlayerMoveData thisMove, PlayerMoveData lastMove) {
        return !thisMove.touchedGround && thisMove.from.inWater && !thisMove.to.resetCond && !lastMove.from.resetCond && lastMove.to.inWater && Magic.excludeStaticSpeed(thisMove) && Magic.excludeStaticSpeed(lastMove);
    }

    public static boolean inAir(PlayerMoveData thisMove) {
        return !thisMove.touchedGround && !thisMove.from.resetCond && !thisMove.to.resetCond;
    }

    static boolean inLiquid(PlayerMoveData thisMove) {
        return thisMove.from.inLiquid && thisMove.to.inLiquid && Magic.excludeStaticSpeed(thisMove);
    }

    static boolean resetCond(PlayerMoveData thisMove) {
        return thisMove.from.resetCond || thisMove.to.resetCond;
    }

    static boolean leavingLiquid(PlayerMoveData thisMove) {
        return thisMove.from.inLiquid && !thisMove.to.inLiquid && Magic.excludeStaticSpeed(thisMove);
    }

    static boolean intoLiquid(PlayerMoveData thisMove) {
        return !thisMove.from.inLiquid && thisMove.to.inLiquid && Magic.excludeStaticSpeed(thisMove);
    }

    public static boolean excludeStaticSpeed(PlayerMoveData thisMove) {
        return !thisMove.from.inWeb && !thisMove.to.inWeb && !thisMove.from.onClimbable && !thisMove.to.onClimbable;
    }

    public static boolean skipPaper(PlayerMoveData thisMove, PlayerMoveData lastMove, MovingData data) {
        if (!data.hasSetBack()) {
            return false;
        }
        double setBackYDistance = thisMove.to.getY() - data.getSetBackY();
        return !lastMove.toIsValid && data.sfJumpPhase == 0 && thisMove.multiMoveCount > 0 && setBackYDistance > 0.0 && setBackYDistance < 0.01 && thisMove.yDistance > 0.0 && thisMove.yDistance < 0.01 && Magic.inAir(thisMove);
    }

    public static boolean fallAfterHeadObstructed(MovingData data, int limit) {
        limit = Math.min(limit, data.playerMoves.getNumberOfPastMoves());
        for (int i = 0; i < limit; ++i) {
            PlayerMoveData move = data.playerMoves.getPastMove(i);
            if (!move.toIsValid || move.yDistance >= 0.0) {
                return false;
            }
            if (!move.headObstructed) continue;
            return true;
        }
        return false;
    }

    public static boolean glideVerticalGainEnvelope(double yDistance, double previousYDistance) {
        return yDistance < -0.1044 && previousYDistance < -0.1044 && yDistance - previousYDistance > -0.0834 && yDistance - previousYDistance < 0.025641025641025644;
    }

    public static boolean glideEnvelopeWithHorizontalGain(PlayerMoveData thisMove, PlayerMoveData lastMove, PlayerMoveData pastMove1) {
        return pastMove1.toIsValid && Magic.glideVerticalGainEnvelope(thisMove.yDistance, lastMove.yDistance) && Magic.glideVerticalGainEnvelope(lastMove.yDistance, pastMove1.yDistance) && lastMove.hDistance > pastMove1.hDistance && thisMove.hDistance > lastMove.hDistance && Math.abs(lastMove.hDistance - pastMove1.hDistance) < 0.0417 && Math.abs(thisMove.hDistance - lastMove.hDistance) < 0.0417;
    }

    public static boolean noobJumpsOffTower(double yDistance, double maxJumpGain, PlayerMoveData thisMove, PlayerMoveData lastMove, MovingData data) {
        PlayerMoveData secondPastMove = data.playerMoves.getSecondPastMove();
        return (data.sfJumpPhase == 1 && lastMove.touchedGroundWorkaround || data.sfJumpPhase == 2 && Magic.inAir(lastMove) && secondPastMove.valid && secondPastMove.touchedGroundWorkaround) && Magic.inAir(thisMove) && lastMove.yDistance < maxJumpGain && lastMove.yDistance > maxJumpGain * 0.67 && Magic.fallingEnvelope(yDistance, maxJumpGain, data.lastFrictionVertical, 0.021000000000000005);
    }
}

