/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.location.tracking;

import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.pool.AbstractPool;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import java.util.Iterator;

public class LocationTrace {
    private final TraceEntryPool pool;
    private long maxAge;
    private int maxSize;
    private int size = 0;
    private TraceEntry firstEntry = null;
    private TraceEntry lastEntry = null;

    public LocationTrace(long maxAge, int maxSize, TraceEntryPool pool) {
        this.pool = pool;
        this.maxAge = maxAge;
        this.maxSize = maxSize;
    }

    public final void addEntry(long time, RichBoundsLocation loc) {
        this.addEntry(time, loc.getX(), loc.getY(), loc.getZ(), loc.getBoxMarginHorizontal(), loc.getBoxMarginVertical());
    }

    public final void addEntry(long time, double x, double y, double z, double boxMarginHorizontal, double boxMarginVertical) {
        if (this.size > 0 && x == this.firstEntry.x && y == this.firstEntry.y && z == this.firstEntry.z && boxMarginHorizontal == this.firstEntry.boxMarginHorizontal && boxMarginVertical == this.firstEntry.boxMarginVertical) {
            return;
        }
        TraceEntry newEntry = (TraceEntry)this.pool.getInstance();
        newEntry.set(time, x, y, z, boxMarginHorizontal, boxMarginVertical);
        this.setFirst(newEntry);
        if (this.size > this.maxSize) {
            this.returnToPool(this.lastEntry);
        }
        this.checkMaxAge(time);
    }

    private void setFirst(TraceEntry entry) {
        entry.previous = null;
        if (this.firstEntry != null) {
            entry.next = this.firstEntry;
            this.firstEntry.previous = entry;
        } else {
            entry.next = null;
            this.lastEntry = entry;
        }
        this.firstEntry = entry;
        ++this.size;
    }

    public void checkMaxAge(long time) {
        if (time - this.lastEntry.time < this.maxAge || this.size == 1) {
            return;
        }
        TraceEntry entry = this.lastEntry;
        while (time - entry.previous.time > this.maxAge) {
            entry = entry.previous;
        }
        this.returnToPool(entry);
    }

    public void reset() {
        this.returnToPool(this.firstEntry);
        this.lastEntry = null;
        this.firstEntry = null;
        this.size = 0;
    }

    private void returnToPool(TraceEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.previous != null) {
            entry.previous.next = null;
        }
        this.lastEntry = entry.previous;
        if (entry == this.firstEntry) {
            this.firstEntry = null;
        }
        while (entry != null) {
            TraceEntry nextEntry = entry.next;
            entry.next = (entry.previous = null);
            this.pool.returnInstance(entry);
            entry = nextEntry;
            --this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public TraceIterator latestIterator() {
        return new TraceIterator(this.firstEntry, true);
    }

    public TraceIterator oldestIterator() {
        return new TraceIterator(this.lastEntry, false);
    }

    public TraceIterator maxAgeIterator(long time) {
        TraceEntry start = this.firstEntry;
        while (start != null && start.next != null && start.next.time >= time) {
            start = start.next;
        }
        return new TraceIterator(start, false);
    }

    public void adjustSettings(long maxAge, int maxSize, long time) {
        if (this.size > 0 && time < this.firstEntry.time) {
            this.reset();
        }
        if (this.maxAge != maxAge) {
            this.maxAge = maxAge;
            this.checkMaxAge(time);
        }
        if (this.maxSize != maxSize) {
            this.maxSize = maxSize;
            TraceEntry entry = this.lastEntry;
            for (int size = this.size; size > maxSize; --size) {
                entry = entry.previous;
            }
            this.returnToPool(entry);
        }
    }

    public static final class TraceIterator
    implements Iterator<ITraceEntry> {
        final TraceEntry first;
        private TraceEntry next;
        final boolean nextIsNext;

        protected TraceIterator(TraceEntry first, boolean nextIsNext) {
            this.first = first;
            this.nextIsNext = nextIsNext;
            this.next = first;
            if (!this.hasNext()) {
                throw new IllegalArgumentException("Empty iterators are not allowed.");
            }
        }

        @Override
        public final ITraceEntry next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("No more entries to iterate.");
            }
            TraceEntry next = this.next;
            this.next = this.nextIsNext ? next.next : next.previous;
            return next;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class TraceEntryPool
    extends AbstractPool<TraceEntry> {
        public TraceEntryPool(int maxPoolSize) {
            super(maxPoolSize);
        }

        @Override
        protected TraceEntry newInstance() {
            return new TraceEntry();
        }
    }

    public static class TraceEntry
    implements ITraceEntry {
        private long time;
        private double x;
        private double y;
        private double z;
        private double boxMarginHorizontal;
        private double boxMarginVertical;
        private TraceEntry next;
        private TraceEntry previous;

        public void set(long time, double x, double y, double z, double boxMarginHorizontal, double boxMarginVertical) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.boxMarginHorizontal = boxMarginHorizontal;
            this.boxMarginVertical = boxMarginVertical;
            this.time = time;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public double getBoxMarginHorizontal() {
            return this.boxMarginHorizontal;
        }

        @Override
        public double getBoxMarginVertical() {
            return this.boxMarginVertical;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public boolean isInside(double x, double y, double z) {
            return y >= this.y && y <= this.y + this.boxMarginVertical && Math.abs(x - this.x) <= this.boxMarginHorizontal && Math.abs(z - this.z) <= this.boxMarginHorizontal;
        }
    }

    public static interface ITraceEntry
    extends IGetPosition {
        public double getBoxMarginHorizontal();

        public double getBoxMarginVertical();

        public long getTime();

        public boolean isInside(double var1, double var3, double var5);
    }
}

